/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BannerMiapiModel;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.material.MaterialInscribeDataProperty;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.RenderProperty;

@OnlyIn(value=Dist.CLIENT)
public class BannerModelProperty
implements RenderProperty {
    public static final String KEY = "banner";
    public static BannerModelProperty property;

    public BannerModelProperty() {
        property = this;
        MiapiItemModel.modelSuppliers.add((key, moduleInstance, stack) -> {
            JsonElement element = moduleInstance.getProperties().get(property);
            ArrayList models = new ArrayList();
            if (element != null && stack.m_41782_()) {
                element.getAsJsonArray().forEach(element1 -> {
                    BannerMiapiModel bannerMiapiModel;
                    SlotProperty.ModuleSlot slot;
                    ModelJson modelJson = (ModelJson)Miapi.gson.fromJson(element1, ModelJson.class);
                    if ("parent".equals(modelJson.modelType) && (slot = SlotProperty.getSlotIn(moduleInstance)) != null) {
                        modelJson.modelType = slot.transform.origin;
                    }
                    Supplier<ItemStack> stackSupplier = switch (modelJson.type) {
                        case "item_nbt" -> {
                            CompoundTag itemCompound = stack.m_41784_().m_128469_(KEY);
                            if (!itemCompound.m_128456_() && ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> ItemStack.m_41712_((CompoundTag)itemCompound);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        case "module_data" -> {
                            if (ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> MaterialInscribeDataProperty.readStackFromModuleInstance(moduleInstance, KEY);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        case "module_data_parent" -> {
                            if (ModelProperty.isAllowedKey(modelJson.modelType, key) && moduleInstance.parent != null) {
                                yield () -> MaterialInscribeDataProperty.readStackFromModuleInstance(moduleInstance.parent, KEY);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        default -> throw new IllegalStateException("Unexpected value: " + modelJson.type);
                    };
                    BannerMiapiModel.BannerMode mode = BannerMiapiModel.getMode(modelJson.model);
                    modelJson.transform = Transform.repair(modelJson.transform);
                    BakedSingleModel model = null;
                    if (modelJson.overWritePath != null) {
                        ModelProperty.UnbakedModelHolder unbaked = ModelProperty.modelCache.get(modelJson.overWritePath);
                        model = DynamicBakery.bakeModel(unbaked.model(), ModelProperty.textureGetter, -16777216, Transform.IDENTITY);
                    }
                    if ((bannerMiapiModel = BannerMiapiModel.getFromStack(stackSupplier.get(), mode, modelJson.transform.toMatrix(), null)) != null) {
                        models.add(bannerMiapiModel);
                    }
                });
            }
            return models;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonArray().forEach(element1 -> {
            ModelJson modelJson = (ModelJson)Miapi.gson.fromJson(element1, ModelJson.class);
            if (modelJson.overWritePath != null) {
                try {
                    ModelProperty.loadModelsByPath(modelJson.overWritePath);
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.info("Exception using custom banner model");
                }
            }
        });
        return true;
    }

    static class ModelJson {
        public String type;
        public String model;
        public String modelType;
        public String overWritePath;
        public Transform transform = Transform.IDENTITY;

        ModelJson() {
        }
    }
}

