/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.potion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.ModuleProperty;

public abstract class PotionEffectProperty
implements ModuleProperty {
    public String KEY;
    public PotionEffectProperty property;

    protected PotionEffectProperty(String key) {
        this.KEY = key;
        this.property = this;
        ModularItemCache.setSupplier(this.KEY + ".status_effects", this::getStatusEffectsCache);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        this.getPotions(data, new ItemModule.ModuleInstance(ItemModule.empty));
        return true;
    }

    public void applyPotions(LivingEntity livingEntity, Iterable<ItemStack> itemStack, @Nullable LivingEntity causer) {
        List<EffectHolder> effectHolders = this.getStatusEffects(itemStack);
        for (EffectHolder effectHolder : effectHolders) {
            livingEntity.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
    }

    public List<EffectHolder> getStatusEffects(ItemStack itemStack) {
        return ModularItemCache.get(itemStack, this.KEY + ".status_effects", new ArrayList());
    }

    public List<EffectHolder> getStatusEffects(ItemStack itemStack, EffectPredicate predicate, LivingEntity livingEntity) {
        ArrayList<EffectHolder> holders = new ArrayList<EffectHolder>();
        this.getStatusEffects(itemStack).stream().filter(effectHolder -> this.isValidForSlot(EquipmentSlot.MAINHAND, (EffectHolder)effectHolder, livingEntity)).filter(effectHolder -> predicate.filterHolder((EffectHolder)effectHolder, EquipmentSlot.MAINHAND)).forEach(holders::add);
        return holders;
    }

    public void applyEffects(LivingEntity target, LivingEntity itemsFromEntity, @Nullable LivingEntity causer) {
        List<EffectHolder> getFilteredEffects = this.getHoldersConditional(itemsFromEntity);
        getFilteredEffects = this.merge(getFilteredEffects);
        for (EffectHolder effectHolder : getFilteredEffects) {
            target.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
    }

    public void applyEffects(LivingEntity target, LivingEntity itemsFromEntity, @Nullable LivingEntity causer, EffectPredicate predicate) {
        List<EffectHolder> getFilteredEffects = this.getHoldersConditional(itemsFromEntity, predicate);
        getFilteredEffects = this.merge(getFilteredEffects);
        for (EffectHolder effectHolder : getFilteredEffects) {
            target.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
    }

    public void applyEffects(LivingEntity target, ItemStack itemStack, @Nullable LivingEntity causer, EffectPredicate predicate) {
        List<EffectHolder> getFilteredEffects = this.getStatusEffects(itemStack);
        getFilteredEffects = this.merge(getFilteredEffects);
        for (EffectHolder effectHolder : getFilteredEffects) {
            target.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
    }

    public void applyEffects(LivingEntity target, LivingEntity itemsFromEntity, ItemStack itemStack, @Nullable LivingEntity causer, EffectPredicate predicate) {
        List<EffectHolder> getFilteredEffects = this.getStatusEffects(itemStack, predicate, itemsFromEntity);
        getFilteredEffects = this.merge(getFilteredEffects);
        for (EffectHolder effectHolder : getFilteredEffects) {
            target.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
        getFilteredEffects = this.getHoldersConditional(itemsFromEntity, predicate);
        getFilteredEffects = this.merge(getFilteredEffects);
        for (EffectHolder effectHolder : getFilteredEffects) {
            target.m_147207_(effectHolder.effectInstance(), (Entity)causer);
        }
    }

    public List<EffectHolder> merge(List<EffectHolder> holders) {
        ArrayList<EffectHolder> filtered = new ArrayList<EffectHolder>();
        HashMap<EffectKey, EffectHolder> effectMap = new HashMap<EffectKey, EffectHolder>();
        for (EffectHolder holder : holders) {
            int amplifier = holder.effectInstance().m_19564_();
            MobEffect effect = holder.statusEffect();
            EffectKey key = new EffectKey(effect, amplifier);
            if (effectMap.containsKey(key)) {
                EffectHolder old = (EffectHolder)effectMap.get(key);
                filtered.remove(old);
                EffectHolder merged = this.mergeEffects(holder, old);
                effectMap.put(key, merged);
                filtered.add(merged);
                continue;
            }
            effectMap.put(key, holder);
            filtered.add(holder);
        }
        return filtered;
    }

    private EffectHolder mergeEffects(EffectHolder toMerge, EffectHolder existing) {
        MobEffectInstance oldInstance = existing.effectInstance();
        MobEffectInstance toMergeInstance = toMerge.effectInstance();
        MobEffectInstance instance = new MobEffectInstance(oldInstance.m_19544_(), oldInstance.m_19557_() + toMergeInstance.m_19557_(), oldInstance.m_19564_(), oldInstance.m_19571_() || toMergeInstance.m_19571_(), oldInstance.m_19572_() || toMergeInstance.m_19572_());
        return new EffectHolder(existing.statusEffect, existing.moduleInstance, existing.rawData, instance);
    }

    public List<EffectHolder> getHoldersConditional(LivingEntity entity, EffectPredicate predicate) {
        ArrayList<EffectHolder> effectHolders = new ArrayList<EffectHolder>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = entity.m_6844_(slot);
            this.getStatusEffects(itemStack).stream().filter(effectHolder -> this.isValidForSlot(slot, (EffectHolder)effectHolder, entity)).filter(effectHolder -> predicate.filterHolder((EffectHolder)effectHolder, slot)).forEach(effectHolders::add);
        }
        return effectHolders;
    }

    public List<EffectHolder> getHoldersConditional(LivingEntity entity) {
        ArrayList<EffectHolder> effectHolders = new ArrayList<EffectHolder>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = entity.m_6844_(slot);
            this.getStatusEffects(itemStack).stream().filter(effectHolder -> this.isValidForSlot(slot, (EffectHolder)effectHolder, entity)).forEach(effectHolders::add);
        }
        return effectHolders;
    }

    public boolean isValidForSlot(EquipmentSlot equipmentSlot, EffectHolder holder, LivingEntity livingEntity) {
        String key;
        switch (key = ModuleProperty.getString(holder.rawData(), "equipment_slot", holder.moduleInstance(), "all")) {
            case "all": {
                return true;
            }
            case "armor": {
                return equipmentSlot.m_254934_();
            }
            case "hand": {
                return !equipmentSlot.m_254934_();
            }
            case "active_hand": {
                switch (livingEntity.m_7655_()) {
                    case OFF_HAND: {
                        return EquipmentSlot.MAINHAND.equals((Object)equipmentSlot);
                    }
                    case MAIN_HAND: {
                        return EquipmentSlot.OFFHAND.equals((Object)equipmentSlot);
                    }
                }
                return false;
            }
        }
        return equipmentSlot.equals((Object)EquipmentSlot.m_20747_((String)key));
    }

    public List<EffectHolder> getStatusEffects(Iterable<ItemStack> items) {
        ArrayList<EffectHolder> potions = new ArrayList<EffectHolder>();
        for (ItemStack itemStack : items) {
            potions.addAll(this.getStatusEffectsCache(itemStack));
        }
        return potions;
    }

    private List<EffectHolder> getStatusEffectsCache(ItemStack itemStack) {
        ArrayList<EffectHolder> potions = new ArrayList<EffectHolder>();
        ItemModule.getModules(itemStack).allSubModules().forEach(moduleInstance -> {
            if (moduleInstance.getProperties().containsKey(this)) {
                potions.addAll(this.getPotions(moduleInstance.getProperties().get(this), (ItemModule.ModuleInstance)moduleInstance));
            }
        });
        return potions;
    }

    public List<EffectHolder> getPotions(JsonElement jsonElement, ItemModule.ModuleInstance moduleInstance) {
        ArrayList<EffectHolder> potions = new ArrayList<EffectHolder>();
        jsonElement.getAsJsonArray().forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            ResourceLocation identifier = new ResourceLocation(ModuleProperty.getString(object, "potion", moduleInstance, ""));
            MobEffect potion = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(identifier);
            if (potion != null) {
                potions.add(this.getHolder(potion, element.getAsJsonObject(), moduleInstance));
            } else {
                Miapi.LOGGER.warn("could not find Potion " + String.valueOf(identifier));
            }
        });
        return potions;
    }

    public EffectHolder getHolder(MobEffect effect, JsonObject object, ItemModule.ModuleInstance moduleInstance) {
        return new EffectHolder(effect, moduleInstance, object, null);
    }

    public record EffectHolder(MobEffect statusEffect, ItemModule.ModuleInstance moduleInstance, JsonObject rawData, MobEffectInstance instance) {
        public boolean isGuiVisibility() {
            return ModuleProperty.getBoolean(this.rawData(), "lore", this.moduleInstance(), true);
        }

        public MobEffectInstance effectInstance() {
            if (this.instance != null) {
                return this.instance;
            }
            int duration = ModuleProperty.getInteger(this.rawData(), "duration", this.moduleInstance(), 10);
            int amplifier = ModuleProperty.getInteger(this.rawData(), "amplifier", this.moduleInstance(), 0);
            boolean ambient = ModuleProperty.getBoolean(this.rawData(), "ambient", this.moduleInstance(), false);
            boolean showParticles = ModuleProperty.getBoolean(this.rawData(), "showParticles", this.moduleInstance(), true);
            boolean showIcon = ModuleProperty.getBoolean(this.rawData(), "showIcon", this.moduleInstance(), showParticles);
            return new MobEffectInstance(this.statusEffect(), duration, amplifier, ambient, showParticles, showIcon);
        }

        public Component getPotionDescription() {
            MutableComponent text = Component.m_237115_((String)this.effectInstance().m_19576_());
            text = (Component)text.m_178405_(Style.f_131099_.m_178520_(this.effectInstance().m_19544_().m_19484_())).get(0);
            return text;
        }

        public int getDurationSeconds() {
            return (int)Math.ceil((float)this.effectInstance().m_19557_() / 20.0f);
        }

        public Component getAmplifier() {
            return Component.m_237115_((String)("potion.potency." + this.effectInstance().m_19564_()));
        }
    }

    public static interface EffectPredicate {
        public boolean filterHolder(EffectHolder var1, EquipmentSlot var2);
    }

    private static class EffectKey {
        private MobEffect effect;
        private int amplifier;

        public EffectKey(MobEffect effect, int amplifier) {
            this.effect = effect;
            this.amplifier = amplifier;
        }

        public int hashCode() {
            return this.effect.hashCode() + this.amplifier;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EffectKey other = (EffectKey)obj;
            return this.effect.equals(other.effect) && this.amplifier == other.amplifier;
        }
    }
}

