/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining.mode;

import com.google.gson.JsonObject;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.mining.MiningShapeProperty;
import smartin.miapi.modules.properties.mining.mode.MiningMode;

public class StaggeredMiningMode
implements MiningMode {
    public float speed = 1.0f;
    public double durabilityBreakChance;
    public static List<Runnable> nextTickTask = new ArrayList<Runnable>();

    @Override
    public MiningMode fromJson(JsonObject object, ItemModule.ModuleInstance moduleInstance) {
        StaggeredMiningMode miningMode = new StaggeredMiningMode();
        miningMode.speed = (float)MiningShapeProperty.getDouble(object, "speed", moduleInstance, 1);
        miningMode.durabilityBreakChance = MiningShapeProperty.getDouble(object, "durability_chance", moduleInstance, 1);
        return miningMode;
    }

    @Override
    public void execute(List<BlockPos> posList, Level world, ServerPlayer player, BlockPos origin, ItemStack itemStack) {
        ArrayList<BlockPos> reducedList = new ArrayList<BlockPos>(posList);
        reducedList.sort(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)origin)));
        nextTickTask.add(() -> {
            int success = 0;
            do {
                BlockPos pos;
                if (!this.tryBreakBlock(player, pos = (BlockPos)reducedList.remove(0))) continue;
                ++success;
                if (player.m_7500_()) continue;
                this.removeDurability(this.durabilityBreakChance, itemStack, world, player);
            } while ((float)success < this.speed && !reducedList.isEmpty() && itemStack.m_41776_() - itemStack.m_41773_() > 1);
            if (!reducedList.isEmpty() && itemStack.m_41776_() - itemStack.m_41773_() > 1) {
                this.execute(reducedList, world, player, origin, itemStack);
            }
        });
    }

    static {
        TickEvent.SERVER_POST.register(server -> {
            ArrayList<Runnable> currentTicks = new ArrayList<Runnable>(nextTickTask);
            nextTickTask.clear();
            currentTicks.forEach(arg_0 -> ((MinecraftServer)server).execute(arg_0));
        });
    }
}

