/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.mining.MiningShapeJson;
import smartin.miapi.modules.properties.mining.condition.AlwaysMiningCondition;
import smartin.miapi.modules.properties.mining.condition.BlockTagCondition;
import smartin.miapi.modules.properties.mining.condition.MiningCondition;
import smartin.miapi.modules.properties.mining.condition.MiningTypeCondition;
import smartin.miapi.modules.properties.mining.mode.InstantMiningMode;
import smartin.miapi.modules.properties.mining.mode.MiningMode;
import smartin.miapi.modules.properties.mining.mode.StaggeredMiningMode;
import smartin.miapi.modules.properties.mining.modifier.FasterMiningModifier;
import smartin.miapi.modules.properties.mining.modifier.MiningModifier;
import smartin.miapi.modules.properties.mining.modifier.SameBlockModifier;
import smartin.miapi.modules.properties.mining.shape.CubeMiningShape;
import smartin.miapi.modules.properties.mining.shape.MiningShape;
import smartin.miapi.modules.properties.mining.shape.VeinMiningShape;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MiningShapeProperty
implements ModuleProperty {
    public static String KEY = "mining_shape";
    public static MiningShapeProperty property;
    public static Map<String, MiningCondition> miningConditionMap;
    public static Map<String, MiningShape> miningShapeMap;
    public static Map<String, MiningMode> miningModeMap;
    public static Map<String, MiningModifier> miningModifierMap;
    public static List<BlockPos> blockedPositions;

    public MiningShapeProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, MiningShapeProperty::getCache);
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (!(level.m_5776_() || player.m_6144_() || blockedPositions.contains(pos))) {
                ItemStack miningItem = player.m_21205_();
                List<MiningShapeJson> miningShapeJsons = this.get(miningItem);
                HitResult hitResult = player.m_19907_(this.getBlockBreakDistance((Player)player), 0.0f, false);
                if (hitResult instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    if (MiapiConfig.INSTANCE.server.other.saveAreaMining && !blockHitResult.m_82425_().equals((Object)pos)) {
                        return EventResult.pass();
                    }
                    Direction facing = blockHitResult.m_82434_();
                    miningShapeJsons.stream().filter(miningShapeJson -> miningShapeJson.miningCondition.canMine((Player)player, level, miningItem, pos, facing)).forEach(miningShapeJson -> miningShapeJson.execute(pos, level, miningItem, player, facing));
                }
            }
            return EventResult.pass();
        });
        miningModeMap.put("instant", new InstantMiningMode(1.0));
        miningModeMap.put("staggered", new StaggeredMiningMode());
        miningModifierMap.put("require_same", new SameBlockModifier());
        miningModifierMap.put("require_faster", new FasterMiningModifier());
        miningConditionMap.put("always", new AlwaysMiningCondition());
        miningConditionMap.put("block_tag", new BlockTagCondition(new ArrayList<TagKey<Block>>()));
        MiningLevelProperty.miningCapabilities.keySet().forEach(s -> miningConditionMap.put((String)s, new MiningTypeCondition((String)s)));
        miningShapeMap.put("cube", new CubeMiningShape());
        miningShapeMap.put("vein", new VeinMiningShape());
    }

    public double getBlockBreakDistance(Player player) {
        return 10.0;
    }

    public List<MiningShapeJson> get(ItemStack stack) {
        return ModularItemCache.get(stack, KEY, new ArrayList());
    }

    private static List<MiningShapeJson> getCache(ItemStack stack) {
        ArrayList<MiningShapeJson> miningShapeJsons = new ArrayList<MiningShapeJson>();
        ItemModule.getModules(stack).allSubModules().forEach(moduleInstance -> {
            JsonElement element = moduleInstance.getProperties().get(property);
            if (element != null) {
                miningShapeJsons.addAll(MiningShapeProperty.get(element, moduleInstance));
            }
        });
        return miningShapeJsons;
    }

    public static List<MiningShapeJson> get(JsonElement element, ItemModule.ModuleInstance moduleInstance) {
        return element.getAsJsonArray().asList().stream().map(subElement -> new MiningShapeJson(subElement.getAsJsonObject(), moduleInstance)).toList();
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        MiningShapeProperty.get(data, new ItemModule.ModuleInstance(ItemModule.empty));
        return true;
    }

    public static boolean getBoolean(JsonObject object, String element, boolean defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull() && json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        return defaultValue;
    }

    public static int getInteger(JsonObject object, String element, int defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull() && json.isJsonPrimitive()) {
            return json.getAsInt();
        }
        return defaultValue;
    }

    public static int getInteger(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, int defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return (int)StatResolver.resolveDouble(json, moduleInstance);
        }
        return defaultValue;
    }

    public static double getDouble(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, int defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return StatResolver.resolveDouble(json, moduleInstance);
        }
        return defaultValue;
    }

    static {
        miningConditionMap = new HashMap<String, MiningCondition>();
        miningShapeMap = new HashMap<String, MiningShape>();
        miningModeMap = new HashMap<String, MiningMode>();
        miningModifierMap = new HashMap<String, MiningModifier>();
        blockedPositions = new ArrayList<BlockPos>();
    }
}

