/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.EnchantAbilityProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.ToolOrWeaponProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MiningLevelProperty
implements ModuleProperty {
    public static MiningLevelProperty property;
    public static final String KEY = "mining_level";
    public static Map<String, TagKey<Block>> miningCapabilities;
    public static Map<TagKey<Block>, Integer> miningLevels;
    public static Item lastFakedItem;
    static Map<ItemStack, Tier> toolMaterialLookup;

    public MiningLevelProperty() {
        property = this;
        miningCapabilities.put("pickaxe", (TagKey<Block>)BlockTags.f_144282_);
        miningCapabilities.put("axe", (TagKey<Block>)BlockTags.f_144280_);
        miningCapabilities.put("shovel", (TagKey<Block>)BlockTags.f_144283_);
        miningCapabilities.put("hoe", (TagKey<Block>)BlockTags.f_144281_);
        miningCapabilities.put("sword", (TagKey<Block>)BlockTags.f_278398_);
        miningLevels.put((TagKey<Block>)BlockTags.f_144286_, 1);
        miningLevels.put((TagKey<Block>)BlockTags.f_144285_, 2);
        miningLevels.put((TagKey<Block>)BlockTags.f_144284_, 3);
        ModularItemCache.setSupplier(KEY, stack -> {
            HashMap mergedMap = new HashMap();
            List<ItemModule.ModuleInstance> modules = ItemModule.getModules(stack).allSubModules();
            modules.forEach(module -> {
                JsonElement element = module.getProperties().get(property);
                if (element != null) {
                    Map<String, JsonElement> map = this.getElements(element);
                    map.forEach((id, jsonElement) -> {
                        float value = (float)StatResolver.resolveDouble(jsonElement, module);
                        boolean contains = mergedMap.containsKey(id);
                        if (!contains || contains && ((Float)mergedMap.get(id)).floatValue() < value) {
                            mergedMap.put(id, Float.valueOf(value));
                        }
                    });
                }
            });
            return mergedMap;
        });
    }

    public static int getMiningLevel(String type, ItemStack stack) {
        Map mergedMap = ModularItemCache.get(stack, KEY, new HashMap());
        Float value = (Float)mergedMap.get(type);
        if (value != null) {
            return value.intValue();
        }
        return 0;
    }

    public static int getMiningLevelHighest(ItemStack stack) {
        int highest = 0;
        highest = Math.max(MiningLevelProperty.getMiningLevel("axe", stack), highest);
        highest = Math.max(MiningLevelProperty.getMiningLevel("pickaxe", stack), highest);
        highest = Math.max(MiningLevelProperty.getMiningLevel("shovel", stack), highest);
        highest = Math.max(MiningLevelProperty.getMiningLevel("hoe", stack), highest);
        return highest;
    }

    public static Tier getFakeToolMaterial(ItemStack itemStack) {
        return toolMaterialLookup.getOrDefault(itemStack, MiningLevelProperty.getFakeToolMaterialCache(itemStack));
    }

    private static Tier getFakeToolMaterialCache(final ItemStack itemStack) {
        return new Tier(){

            public int m_6609_() {
                try {
                    return (int)DurabilityProperty.property.getValueSafe(itemStack);
                }
                catch (RuntimeException e) {
                    return 50;
                }
            }

            public float m_6624_() {
                try {
                    return MiningLevelProperty.getHighestMiningSpeedMultiplier(itemStack);
                }
                catch (RuntimeException e) {
                    return 5.0f;
                }
            }

            public float m_6631_() {
                try {
                    return (int)AttributeProperty.getActualValueCache(itemStack, EquipmentSlot.MAINHAND, Attributes.f_22281_, 1.0);
                }
                catch (RuntimeException e) {
                    return 1.0f;
                }
            }

            public int m_6604_() {
                try {
                    return MiningLevelProperty.getMiningLevelHighest(itemStack);
                }
                catch (RuntimeException e) {
                    return 0;
                }
            }

            public int m_6601_() {
                try {
                    return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
                }
                catch (RuntimeException e) {
                    return 10;
                }
            }

            public Ingredient m_6282_() {
                try {
                    return RepairPriority.asRepairIngredient(itemStack);
                }
                catch (RuntimeException e) {
                    return Ingredient.f_43901_;
                }
            }
        };
    }

    public static boolean isSuitable(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_) && stack.m_41720_() instanceof SwordItem) {
            return true;
        }
        Map mergedMap = ModularItemCache.get(stack, KEY, new HashMap());
        for (Map.Entry<String, TagKey<Block>> entry : miningCapabilities.entrySet()) {
            Float level;
            if (!state.m_204336_(entry.getValue()) || (level = (Float)mergedMap.get(entry.getKey())) == null) continue;
            for (Map.Entry<TagKey<Block>, Integer> miningLevelEntry : miningLevels.entrySet()) {
                if (!state.m_204336_(miningLevelEntry.getKey())) continue;
                return (float)miningLevelEntry.getValue().intValue() <= level.floatValue();
            }
            return true;
        }
        return false;
    }

    public static boolean isSuitable(ItemStack stack, String type) {
        if (MiningLevelProperty.getMiningLevel(type, stack) > 0) {
            return true;
        }
        return MiningLevelProperty.getMiningSpeedMultiplier(stack, type) > 1.0f;
    }

    public static boolean canMine(BlockState state, Level world, BlockPos pos, Player miner) {
        ItemStack stack = miner.m_21211_();
        if (ToolOrWeaponProperty.isWeapon(stack)) {
            return !miner.m_7500_();
        }
        return true;
    }

    public static float getMiningSpeedMultiplier(ItemStack stack, String type) {
        Multimap<Attribute, AttributeModifier> attributes = AttributeProperty.equipmentSlotMultimapMap(stack).get(EquipmentSlot.MAINHAND);
        return switch (type) {
            case "axe" -> (float)AttributeProperty.getActualValue(attributes, AttributeRegistry.MINING_SPEED_AXE, 1.0);
            case "pickaxe" -> (float)AttributeProperty.getActualValue(attributes, AttributeRegistry.MINING_SPEED_PICKAXE, 1.0);
            case "shovel" -> (float)AttributeProperty.getActualValue(attributes, AttributeRegistry.MINING_SPEED_SHOVEL, 1.0);
            case "hoe" -> (float)AttributeProperty.getActualValue(attributes, AttributeRegistry.MINING_SPEED_HOE, 1.0);
            case "sword" -> {
                if (stack.m_41720_() instanceof SwordItem) {
                    yield 1.5f;
                }
                yield 0.0f;
            }
            default -> 1.0f;
        };
    }

    public static float getMiningSpeedMultiplier(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144282_)) {
            double value = AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_PICKAXE, 1.0);
            return value == 0.0 ? 1.0f : (float)value;
        }
        if (state.m_204336_(BlockTags.f_144280_)) {
            double value = AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_AXE, 1.0);
            return value == 0.0 ? 1.0f : (float)value;
        }
        if (state.m_204336_(BlockTags.f_144283_)) {
            double value = AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_SHOVEL, 1.0);
            return value == 0.0 ? 1.0f : (float)value;
        }
        if (state.m_204336_(BlockTags.f_144281_)) {
            double value = AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_HOE, 1.0);
            return value == 0.0 ? 1.0f : (float)value;
        }
        if (stack.m_41720_() instanceof SwordItem) {
            if (state.m_60713_(Blocks.f_50033_)) {
                return 15.0f;
            }
            return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
        }
        return 1.0f;
    }

    public static float getHighestMiningSpeedMultiplier(ItemStack stack) {
        float start = 0.0f;
        start = (float)Math.max((double)start, AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_PICKAXE, 1.0));
        start = (float)Math.max((double)start, AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_AXE, 1.0));
        start = (float)Math.max((double)start, AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_SHOVEL, 1.0));
        start = (float)Math.max((double)start, AttributeProperty.getActualValueCache(stack, EquipmentSlot.MAINHAND, AttributeRegistry.MINING_SPEED_HOE, 1.0));
        return start;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Map<String, JsonElement> matchedElements = this.getElements(data);
        if (matchedElements.isEmpty()) {
            throw new InvalidParameterException("At least one Mining type is required");
        }
        return true;
    }

    private Map<String, JsonElement> getElements(JsonElement element) {
        HashMap<String, JsonElement> matchedElements = new HashMap<String, JsonElement>();
        if (element != null) {
            for (String key : miningCapabilities.keySet()) {
                if (!element.getAsJsonObject().has(key)) continue;
                matchedElements.put(key, element.getAsJsonObject().get(key));
            }
        }
        return matchedElements;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        return ModuleProperty.super.merge(old, toMerge, type);
    }

    static {
        miningCapabilities = new HashMap<String, TagKey<Block>>();
        miningLevels = new HashMap<TagKey<Block>, Integer>();
        toolMaterialLookup = Collections.synchronizedMap(new WeakHashMap());
    }
}

