/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.compat.better_combat;

import com.google.gson.JsonElement;
import com.google.gson.stream.JsonReader;
import dev.architectury.platform.Platform;
import java.io.Reader;
import java.io.StringReader;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.compat.better_combat.BetterCombatProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class BetterCombatHelper {
    public static void setup() {
        ModularItemCache.setSupplier(BetterCombatProperty.KEY, itemStack -> new AttributeHolder(BetterCombatHelper.getAttributesContainer(itemStack)));
    }

    private static float getAttackRange(ItemStack stack) {
        if (Platform.isForge()) {
            return (float)(AttributeProperty.getActualValueFrom(AttributeProperty.getAttributeModifiersRaw(stack), EquipmentSlot.MAINHAND, AttributeRegistry.ATTACK_RANGE, AttributeRegistry.ATTACK_RANGE.m_22082_()) - 0.5);
        }
        return (float)(AttributeProperty.getActualValueFrom(AttributeProperty.getAttributeModifiersRaw(stack), EquipmentSlot.MAINHAND, AttributeRegistry.ATTACK_RANGE, AttributeRegistry.ATTACK_RANGE.m_22082_()) + 2.5);
    }

    public static WeaponAttributes getAttributesContainer(ItemStack stack) {
        if (stack.m_41720_() instanceof ModularItem) {
            WeaponAttributes attributes = BetterCombatHelper.container(ItemModule.getMergedProperty(stack, (ModuleProperty)BetterCombatProperty.property));
            if (attributes != null) {
                attributes = new WeaponAttributes((attributes.attackRange() + (double)BetterCombatHelper.getAttackRange(stack)) / 2.0, attributes.pose(), attributes.offHandPose(), Boolean.valueOf(attributes.isTwoHanded()), attributes.category(), attributes.attacks());
            }
            return attributes;
        }
        return null;
    }

    private static WeaponAttributes container(JsonElement data) {
        if (data == null) {
            return null;
        }
        String jsonString = data.toString();
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonString));
        return WeaponRegistry.resolveAttributes((ResourceLocation)new ResourceLocation("miapi", "modular_item"), (AttributesContainer)WeaponAttributesHelper.decode((JsonReader)jsonReader));
    }

    public static ItemStack applyNBT(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ModularItem) {
            WeaponAttributes container = BetterCombatHelper.getAttributesContainer(itemStack);
            if (container != null) {
                WeaponAttributesHelper.writeToNBT((ItemStack)itemStack, (AttributesContainer)new AttributesContainer(null, container));
            } else {
                itemStack.m_41784_().m_128473_("weapon_attributes");
            }
        }
        return itemStack;
    }

    @Nullable
    public static WeaponAttributes getAttributes(ItemStack stack) {
        return ModularItemCache.get(stack, BetterCombatProperty.KEY, new AttributeHolder(null)).attributes();
    }

    public record AttributeHolder(WeaponAttributes attributes) {
    }
}

