/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.compat.apoli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ApoliPowersProperty
implements ModuleProperty {
    public static final String KEY = "apoli_powers";
    public static ApoliPowersProperty property;

    public ApoliPowersProperty() {
        property = this;
    }

    public static List<PowerJson> getPowerJson(ItemStack itemStack) {
        JsonElement json;
        ArrayList<PowerJson> powers = new ArrayList<PowerJson>();
        if (itemStack.m_41720_() instanceof ModularItem && (json = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property)) != null) {
            json.getAsJsonArray().forEach(jsonElement -> powers.add(new PowerJson(jsonElement.getAsJsonObject())));
        }
        return powers;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonArray().forEach(jsonElement -> new PowerJson(jsonElement.getAsJsonObject()));
        return Platform.isModLoaded((String)"apoli");
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case OVERWRITE: {
                return toMerge.deepCopy();
            }
            case SMART: 
            case EXTEND: {
                JsonArray array = old.deepCopy().getAsJsonArray();
                array.addAll(toMerge.deepCopy().getAsJsonArray());
                return Miapi.gson.toJsonTree((Object)array);
            }
        }
        return old;
    }

    public static class PowerJson {
        public EquipmentSlot slot;
        public ResourceLocation powerId;
        public boolean isHidden;
        public boolean isNegative;

        public PowerJson(JsonObject element) {
            this.slot = AttributeProperty.getSlot(element.get("slot").getAsString());
            this.powerId = new ResourceLocation(element.get("powerId").getAsString());
            this.isHidden = element.get("isHidden").getAsBoolean();
            this.isNegative = element.get("isNegative").getAsBoolean();
        }
    }
}

