/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class TagProperty
implements ModuleProperty {
    public static final String KEY = "tag";
    public static TagProperty property;

    public TagProperty() {
        property = this;
    }

    public static List<String> getTags(ItemStack itemStack) {
        return TagProperty.getTags(ItemModule.getMergedProperty(itemStack, (ModuleProperty)property));
    }

    public static List<String> getTags(ItemModule.ModuleInstance instance) {
        return TagProperty.getTags(instance.getProperties());
    }

    public static List<String> getTags(Map<ModuleProperty, JsonElement> map) {
        return TagProperty.getTags(map.get(property));
    }

    public static List<String> getTags(JsonElement data) {
        ArrayList<String> tags = new ArrayList<String>();
        if (data != null) {
            data.getAsJsonArray().forEach(element -> tags.add(element.getAsString()));
        }
        return tags;
    }

    public static List<ItemModule> getModulesWithTag(String tag) {
        ArrayList<ItemModule> modules = new ArrayList<ItemModule>();
        ItemModule.moduleRegistry.getFlatMap().forEach((key, module) -> {
            if (TagProperty.getTags(module.getKeyedProperties()).contains(tag)) {
                modules.add((ItemModule)module);
            }
        });
        return modules;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonArray().forEach(JsonElement::getAsString);
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case SMART: 
            case EXTEND: {
                JsonElement element = old.deepCopy();
                element.getAsJsonArray().addAll(toMerge.getAsJsonArray());
                return element;
            }
            case OVERWRITE: {
                return toMerge;
            }
        }
        return old;
    }
}

