/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class StringNBTWriteProperty
implements ModuleProperty,
CraftingProperty {
    public static StringNBTWriteProperty property;
    public static String KEY;

    public StringNBTWriteProperty() {
        property = this;
    }

    public Map<String, Tag> customNBT(ItemStack itemStack) {
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        ItemModule.getModules(itemStack).allSubModules().forEach(moduleInstance -> {
            JsonElement data = moduleInstance.getProperties().get(property);
            if (data != null) {
                data.getAsJsonObject().asMap().forEach((key, json) -> {
                    try {
                        String string = StringNBTWriteProperty.resolveStatInString(json.getAsString(), moduleInstance);
                        map.put((String)key, (Tag)NbtUtils.m_178024_((String)string));
                    }
                    catch (CommandSyntaxException e) {
                        Miapi.LOGGER.warn("could not parse NBT", (Throwable)e);
                    }
                });
            }
        });
        return map;
    }

    public static String resolveStatInString(String input, ItemModule.ModuleInstance moduleInstance) {
        Pattern pattern = Pattern.compile("\\|miapi(.*?)end\\|");
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        while (matcher.find()) {
            result.append(input, lastIndex, matcher.start());
            String statExpression = matcher.group(1);
            double resolvedValue = StatResolver.resolveDouble(statExpression, moduleInstance);
            result.append(resolvedValue);
            lastIndex = matcher.end();
        }
        result.append(input.substring(lastIndex));
        return result.toString();
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ItemModule.ModuleInstance module, ItemModule.ModuleInstance root, ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        Map<String, Tag> oldData = this.customNBT(old);
        Map<String, Tag> newData = this.customNBT(old);
        for (String key : oldData.keySet()) {
            crafting.m_41749_(key);
        }
        for (String key : newData.keySet()) {
            crafting.m_41700_(key, oldData.get(key));
        }
        return crafting;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonObject();
        return true;
    }

    static {
        KEY = "string-nbt";
    }
}

