/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.TransformMap;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.AllowedSlots;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class SlotProperty
implements ModuleProperty {
    public static final String KEY = "slots";

    public static SlotProperty getInstance() {
        return (SlotProperty)RegistryInventory.moduleProperties.get(KEY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Transform getTransform(ItemModule.ModuleInstance instance) {
        ModuleSlot slot = SlotProperty.getSlotIn(instance);
        if (slot == null) {
            return Transform.IDENTITY;
        }
        ItemModule.ModuleInstance current = instance;
        Transform merged = Transform.IDENTITY;
        while (current != null) {
            merged = Transform.merge(SlotProperty.getLocalTransform(current), merged);
            current = current.parent;
        }
        return SlotProperty.getTransform(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Transform getTransform(ModuleSlot moduleSlot) {
        ItemModule.ModuleInstance current = moduleSlot.parent;
        Transform mergedTransform = Transform.IDENTITY;
        while (current != null) {
            mergedTransform = Transform.merge(SlotProperty.getLocalTransform(current), mergedTransform);
            current = current.parent;
        }
        mergedTransform = Transform.merge(mergedTransform, moduleSlot.transform);
        return mergedTransform;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Transform getTransform(ModuleSlot moduleSlot, String id) {
        return SlotProperty.getTransformStack(moduleSlot).get(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getTransformStack(ItemModule.ModuleInstance instance) {
        ModuleSlot slot = SlotProperty.getSlotIn(instance);
        if (slot == null) {
            return new TransformMap();
        }
        return SlotProperty.getTransformStack(slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getTransformStack(ModuleSlot moduleSlot) {
        if (moduleSlot == null) {
            return new TransformMap();
        }
        ItemModule.ModuleInstance current = moduleSlot.parent;
        TransformMap mergedTransform = new TransformMap();
        while (current != null) {
            TransformMap stack = SlotProperty.getLocalTransformStack(current);
            if (mergedTransform.primary == null && stack.primary != null) {
                mergedTransform.set(stack.primary, mergedTransform.get(null));
                mergedTransform.set(null, Transform.IDENTITY);
            }
            mergedTransform = TransformMap.merge(stack, mergedTransform);
            current = current.parent;
        }
        mergedTransform = TransformMap.merge(moduleSlot.getTransformStack(), mergedTransform);
        return mergedTransform;
    }

    public static Map<Integer, ModuleSlot> getSlots(ItemModule.ModuleInstance instance) {
        ModuleProperty property = RegistryInventory.moduleProperties.get(KEY);
        JsonElement data = instance.getProperties().get(property);
        if (data != null) {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<Integer, ModuleSlot>>(){}.getType();
            Map slots = (Map)gson.fromJson(data, type);
            slots.forEach((number, slot) -> {
                slot.inSlot = instance.subModules.get(number);
                slot.parent = instance;
                slot.id = number;
                if (slot.translationKey == null) {
                    slot.translationKey = "miapi.module.empty.name";
                }
                if (slot.slotType == null) {
                    slot.slotType = "default";
                }
            });
            return slots;
        }
        return new HashMap<Integer, ModuleSlot>();
    }

    public static Integer getSlotNumberIn(ItemModule.ModuleInstance instance) {
        if (instance.parent != null) {
            Map<Integer, ModuleSlot> slots = SlotProperty.getSlots(instance.parent);
            AtomicReference<Integer> id = new AtomicReference<Integer>(0);
            slots.forEach((number, moduleSlot) -> {
                if (moduleSlot.inSlot == instance) {
                    id.set((Integer)number);
                }
            });
            return id.get();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Transform getLocalTransform(ItemModule.ModuleInstance instance) {
        ModuleSlot slot;
        ModuleProperty property = RegistryInventory.moduleProperties.get(KEY);
        JsonElement test = instance.getProperties().get(property);
        if (test != null && (slot = SlotProperty.getSlotIn(instance)) != null) {
            return slot.transform;
        }
        return Transform.IDENTITY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TransformMap getLocalTransformStack(ItemModule.ModuleInstance instance) {
        ModuleSlot slot;
        ModuleProperty property = RegistryInventory.moduleProperties.get(KEY);
        JsonElement test = instance.getProperties().get(property);
        if (test != null && (slot = SlotProperty.getSlotIn(instance)) != null) {
            Transform transform = slot.transform;
            TransformMap stack = new TransformMap();
            stack.add(transform);
            stack.primary = transform.origin;
            return stack;
        }
        return new TransformMap();
    }

    @Nullable
    public static ModuleSlot getSlotIn(ItemModule.ModuleInstance instance) {
        if (instance != null && instance.parent != null) {
            Map<Integer, ModuleSlot> slots = SlotProperty.getSlots(instance.parent);
            ModuleSlot slot = slots.values().stream().filter(moduleSlot -> {
                if (moduleSlot.inSlot == null) {
                    return false;
                }
                return moduleSlot.inSlot.equals(instance);
            }).findFirst().orElse(null);
            if (slot != null && slot.transform.origin != null && slot.transform.origin.equals("")) {
                slot.transform.origin = null;
            }
            if (slot != null && slot.translationKey == null) {
                slot.translationKey = "miapi.module.empty.name";
            }
            return slot;
        }
        return null;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<Integer, ModuleSlot>>(){}.getType();
        gson.fromJson(data, type);
        return true;
    }

    public static class ModuleSlot {
        public List<String> allowed;
        public Transform transform = Transform.IDENTITY;
        @Nullable
        public ItemModule.ModuleInstance inSlot;
        public ItemModule.ModuleInstance parent;
        public String translationKey = "miapi.module.empty.name";
        public String slotType = "default";
        public int id;

        public ModuleSlot(List<String> allowedList) {
            this.allowed = allowedList;
            this.id = 0;
        }

        public boolean allowedIn(ItemModule.ModuleInstance instance) {
            List<String> allowedSlots = AllowedSlots.getAllowedSlots(instance.module);
            for (String key : this.allowed) {
                if (!allowedSlots.contains(key)) continue;
                return true;
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public TransformMap getTransformStack() {
            TransformMap stack = new TransformMap();
            stack.add(this.transform);
            return stack;
        }

        public boolean equals(Object object) {
            if (object instanceof ModuleSlot) {
                ModuleSlot slot = (ModuleSlot)object;
                if (this.parent == null && slot.parent != null) {
                    return false;
                }
                if (this.parent != null && !this.parent.equals(slot.parent)) {
                    return false;
                }
                if (this.inSlot == null && slot.inSlot != null) {
                    return false;
                }
                if (this.inSlot != null && !this.inSlot.equals(slot.inSlot)) {
                    return false;
                }
                if (this.allowed == null && slot.allowed != null) {
                    return false;
                }
                if (this.allowed != null) {
                    ArrayList<String> sortedAllowed = new ArrayList<String>(this.allowed);
                    Collections.sort(sortedAllowed);
                    ArrayList<String> sortedOtherAllowed = new ArrayList<String>(slot.allowed);
                    Collections.sort(sortedOtherAllowed);
                    if (!sortedAllowed.equals(sortedOtherAllowed)) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

