/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class RepairPriority
extends DoubleProperty {
    public static RepairPriority property;
    public static final String KEY = "repairPriority";

    public RepairPriority() {
        super(KEY);
        property = this;
        this.allowVisualOnly = true;
        ModularItemCache.setSupplier("repairPriority_materials", this::getRepairMaterialsPrivate);
    }

    public List<Material> getRepairMaterials(ItemStack itemStack) {
        return ModularItemCache.getVisualOnlyCache(itemStack, "repairPriority_materials", new ArrayList());
    }

    public static double getRepairValue(ItemStack tool, ItemStack material) {
        double highestValue = 0.0;
        for (Material material1 : property.getRepairMaterials(tool)) {
            highestValue = Math.max(highestValue, material1.getValueOfItem(material));
        }
        return highestValue;
    }

    public static Ingredient asRepairIngredient(ItemStack tool) {
        for (Material repairing : property.getRepairMaterials(tool)) {
            Ingredient found = repairing.getIngredient();
            if (found == null) continue;
            return found;
        }
        return Ingredient.f_43901_;
    }

    private List<Material> getRepairMaterialsPrivate(ItemStack itemStack) {
        Material material;
        Double value;
        double lowest = Double.MAX_VALUE;
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            value = this.getValueForModule(moduleInstance, null);
            material = MaterialProperty.getMaterial(moduleInstance);
            if (value == null || material == null || !(lowest > value)) continue;
            lowest = value;
        }
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            value = this.getValueForModule(moduleInstance, null);
            material = MaterialProperty.getMaterial(moduleInstance);
            if (value == null || material == null || !(Math.abs(lowest - value) < 0.001)) continue;
            materials.add(material);
        }
        return materials;
    }

    @Override
    public Double getValue(ItemStack stack) {
        return null;
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        return 0.0;
    }
}

