/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import dev.architectury.event.EventResult;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.phys.HitResult;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.mixin.DispenserBlockAccessor;
import smartin.miapi.mixin.ProjectileDispenserBehaviorAccessor;
import smartin.miapi.mixin.ProjectileEntityAccessor;
import smartin.miapi.mixin.ThrowablePotionItemAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ProjectileTriggerProperty
implements ModuleProperty {
    public static final String KEY = "replace_projectile";
    public static ProjectileTriggerProperty property;

    public ProjectileTriggerProperty() {
        property = this;
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            if (ProjectileTriggerProperty.isTriggered(event.projectile, (HitResult)event.entityHitResult)) {
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.register(event -> {
            if (ProjectileTriggerProperty.isTriggered(event.projectile, (HitResult)event.blockHitResult)) {
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
    }

    public static boolean isTriggered(ItemProjectileEntity projectile, HitResult hitResult) {
        CompoundTag itemCompound;
        ItemStack itemStack = projectile.m_7941_();
        JsonElement element = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property);
        if (element != null && itemStack.m_41782_() && !(itemCompound = itemStack.m_41784_().m_128469_(element.getAsString())).m_128456_()) {
            ItemStack storedStack = ItemStack.m_41712_((CompoundTag)itemCompound);
            Entity entity = projectile.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!projectile.m_9236_().m_5776_() && storedStack.m_41720_() instanceof ThrowablePotionItem) {
                    ThrownPotion potionEntity = new ThrownPotion(projectile.m_9236_(), livingEntity);
                    potionEntity.m_146884_(projectile.m_20182_());
                    potionEntity.m_37446_(storedStack);
                    potionEntity.m_37251_((Entity)livingEntity, projectile.m_146909_(), projectile.m_146908_(), 0.0f, projectile.f_146794_, 0.0f);
                    projectile.m_9236_().m_7967_((Entity)potionEntity);
                    ((ThrowablePotionItemAccessor)potionEntity).onCollisionMixin(hitResult);
                    projectile.m_146870_();
                    return true;
                }
                DispenseItemBehavior dispenserBehavior = DispenserBlockAccessor.getBehaviours().get(storedStack.m_41720_());
                if (dispenserBehavior instanceof AbstractProjectileDispenseBehavior) {
                    AbstractProjectileDispenseBehavior projectileDispenserBehavior = (AbstractProjectileDispenseBehavior)dispenserBehavior;
                    Projectile projectileEntity = ((ProjectileDispenserBehaviorAccessor)projectileDispenserBehavior).createProjectileAccessor(projectile.m_9236_(), (Position)projectile.m_20182_(), storedStack);
                    ((ProjectileEntityAccessor)projectileEntity).onCollisionMixin(hitResult);
                }
            }
        }
        return false;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsString();
        return true;
    }
}

