/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.redpxnda.nucleus.math.MathUtil;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.FakeEnchantment;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class ImmolateProperty
extends DoubleProperty {
    public static final String KEY = "immolate";
    public static ImmolateProperty property;

    public ImmolateProperty() {
        super(KEY);
        property = this;
        FakeEnchantment.addTransformer(Enchantments.f_44966_, (stack, level) -> {
            int toLevel = (int)Math.ceil(this.getValueSafe(stack) / 4.0) + level;
            return Math.min(toLevel + level, Math.max(4, level));
        });
        TickEvent.PLAYER_POST.register(player -> {
            double strength;
            if (player.m_9236_().m_5776_()) {
                return;
            }
            if (player.f_19797_ % 250 == 0 && (strength = this.getForItems(player.m_20158_())) > 0.0) {
                double chance = Math.min(1.0, strength * 0.05 + 0.05);
                if (MathUtil.random((double)0.0, (double)1.0) < chance) {
                    double ticksExtention = strength * 2.0;
                    int fireTicks = (int)Math.ceil(MathUtil.random((double)(50.0 + ticksExtention), (double)(80.0 + ticksExtention * 1.5)));
                    ImmolateProperty.setOnFireFor((Entity)player, fireTicks);
                }
            }
        });
        PlayerEvent.ATTACK_ENTITY.register((player, level, target, hand, result) -> {
            if (player.m_9236_().m_5776_()) {
                return EventResult.pass();
            }
            double strength = this.getForItems(player.m_6167_());
            if (strength > 0.0) {
                int fireTicks;
                double ticksExtention;
                double chance = Math.min(1.0, strength * 0.05 + 0.2);
                if (MathUtil.random((double)0.0, (double)1.0) < chance) {
                    ticksExtention = strength * 2.0;
                    fireTicks = (int)Math.ceil(MathUtil.random((double)(50.0 + ticksExtention), (double)(80.0 + ticksExtention * 1.5)));
                    ImmolateProperty.setOnFireFor((Entity)player, fireTicks);
                }
                if (!target.m_5825_()) {
                    ticksExtention = strength * 2.0;
                    fireTicks = (int)Math.ceil(MathUtil.random((double)(50.0 + ticksExtention), (double)(80.0 + ticksExtention * 1.5)));
                    ImmolateProperty.setOnFireFor(target, fireTicks);
                }
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (player.m_9236_().m_5776_()) {
                return EventResult.pass();
            }
            double strength = this.getForItems(player.m_6167_());
            if (strength > 0.0) {
                double chance = Math.min(1.0, strength * 0.05 + 0.2);
                if (MathUtil.random((double)0.0, (double)1.0) < chance) {
                    double ticksExtention = strength * 2.0;
                    int fireTicks = (int)Math.ceil(MathUtil.random((double)(50.0 + ticksExtention), (double)(80.0 + ticksExtention * 1.5)));
                    ImmolateProperty.setOnFireFor((Entity)player, fireTicks);
                }
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(modularProjectileEntityHitEvent -> {
            if (modularProjectileEntityHitEvent.projectile.m_9236_().m_5776_()) {
                return EventResult.pass();
            }
            double strength = this.getValueSafe(modularProjectileEntityHitEvent.projectile.m_7941_());
            ItemStack bowItem = modularProjectileEntityHitEvent.projectile.getBowItem();
            if (bowItem != null && !bowItem.m_41619_()) {
                strength += this.getValueSafe(modularProjectileEntityHitEvent.projectile.getBowItem());
            }
            if (strength > 0.0) {
                LivingEntity living;
                Entity entity;
                double chance = Math.min(1.0, strength * 0.1 + 0.4);
                if (MathUtil.random((double)0.0, (double)1.0) < chance && (entity = modularProjectileEntityHitEvent.entityHitResult.m_82443_()) instanceof LivingEntity && !(living = (LivingEntity)entity).m_5825_()) {
                    double ticksExtention = strength * 2.0;
                    int fireTicks = (int)Math.ceil(MathUtil.random((double)(50.0 + ticksExtention), (double)(80.0 + ticksExtention * 1.5)));
                    ImmolateProperty.setOnFireFor((Entity)living, fireTicks);
                }
            }
            return EventResult.pass();
        });
    }

    @Override
    public Double getValue(ItemStack stack) {
        return this.getValueRaw(stack);
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        return this.getValueSafeRaw(stack);
    }

    public static void setOnFireFor(Entity entity, int ticks) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ticks = ProtectionEnchantment.m_45138_((LivingEntity)living, (int)ticks);
        }
        if (entity.m_20094_() < ticks) {
            entity.m_7311_(ticks);
        }
    }
}

