/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class HealthPercentDamage
extends DoubleProperty {
    public static final String KEY = "healthPercent";
    public static HealthPercentDamage property;

    public HealthPercentDamage() {
        super(KEY);
        property = this;
        MiapiEvents.LIVING_HURT.register(livingHurtEvent -> {
            Entity patt770$temp = livingHurtEvent.damageSource.m_7639_();
            if (patt770$temp instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)patt770$temp;
                ItemStack itemStack = livingHurtEvent.getCausingItemStack();
                if (livingAttacker instanceof Player) {
                    Player player = (Player)livingAttacker;
                    if ((double)player.f_20920_ != 0.0) {
                        return EventResult.pass();
                    }
                }
                double percentage = this.getValueSafe(itemStack);
                double increasingBy = (double)livingHurtEvent.defender.m_21223_() / (100.0 / percentage);
                livingHurtEvent.amount = (float)((double)livingHurtEvent.amount + increasingBy);
            }
            return EventResult.pass();
        });
    }

    @Override
    public Double getValue(ItemStack stack) {
        Double value = property.getValueRaw(stack);
        if (value == null) {
            return null;
        }
        return 200.0 / (1.0 + Math.exp(-Math.sqrt(value) / 50.0)) - 100.0;
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        Double value = property.getValueRaw(stack);
        if (value == null) {
            return 0.0;
        }
        return 200.0 / (1.0 + Math.exp(-Math.sqrt(value) / 50.0)) - 100.0;
    }
}

