/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.BooleanProperty;

public class HandheldItemProperty
extends BooleanProperty {
    public static UUID attackspeedUUID = UUID.fromString("134d982f-c8ab-4b04-969f-15b495f89abd");
    public static String KEY = "handheld_item";

    public HandheldItemProperty() {
        super(KEY, false);
        MiapiEvents.PLAYER_EQUIP_EVENT.register((player, changes) -> {
            if (player instanceof ServerPlayer) {
                boolean hasAttribute;
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                ItemStack mainHandItem = changes.getOrDefault(EquipmentSlot.MAINHAND, player.m_6844_(EquipmentSlot.MAINHAND));
                ItemStack offHandItem = changes.getOrDefault(EquipmentSlot.OFFHAND, player.m_6844_(EquipmentSlot.OFFHAND));
                boolean bl = hasAttribute = serverPlayerEntity.m_21204_().m_22146_(Attributes.f_22283_).m_22111_(attackspeedUUID) != null;
                if (this.hasTwoHandhelds(mainHandItem, offHandItem)) {
                    if (!hasAttribute) {
                        Miapi.LOGGER.info("add handheld buff");
                        serverPlayerEntity.m_21204_().m_22146_(Attributes.f_22283_).m_22118_(new AttributeModifier(attackspeedUUID, "temphandheldboni", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                } else if (hasAttribute) {
                    Miapi.LOGGER.info("remove handheld buff");
                    serverPlayerEntity.m_21204_().m_22146_(Attributes.f_22283_).m_22120_(attackspeedUUID);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            Player serverPlayerEntity;
            Entity patt2977$temp;
            if (event.damageSource != null && (patt2977$temp = event.damageSource.m_7639_()) instanceof Player && this.hasTwoHandhelds(serverPlayerEntity = (Player)patt2977$temp) && !Platform.isModLoaded((String)"bettercombat")) {
                this.swapHands(serverPlayerEntity);
            }
            return EventResult.pass();
        });
        LoreProperty.loreSuppliers.add((stack, world, tooltip, context) -> {
            if (this.hasValue(stack)) {
                tooltip.add(Component.m_237115_((String)"miapi.handheld.tooltip"));
            }
        });
    }

    public void swapHands(Player playerEntity) {
        ItemStack itemStack = playerEntity.m_6844_(EquipmentSlot.OFFHAND);
        playerEntity.m_8061_(EquipmentSlot.OFFHAND, playerEntity.m_6844_(EquipmentSlot.MAINHAND));
        playerEntity.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    public boolean hasTwoHandhelds(Player player) {
        return this.hasTwoHandhelds(player.m_6844_(EquipmentSlot.MAINHAND), player.m_6844_(EquipmentSlot.OFFHAND));
    }

    public boolean hasTwoHandhelds(ItemStack mainHand, ItemStack offHand) {
        return this.hasValue(mainHand) && this.hasValue(offHand);
    }
}

