/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GuiWidgetProperty<T extends InteractAbleWidget>
implements StatListWidget.StatWidgetSupplier,
ModuleProperty {
    public GuiWidgetProperty() {
        StatListWidget.jsonConverterMap.put("double", (element, readerHelper) -> {
            JsonObject object = element.getAsJsonObject();
            Component header = (Component)ExtraCodecs.f_252442_.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("header")).result().orElse(Component.m_237119_());
            Component description = (Component)ExtraCodecs.f_252442_.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("description")).result().orElse(Component.m_237119_());
            double min = this.getOrDefault(object, "min", 0.0);
            double max = this.getOrDefault(object, "max", 10.0);
            return new JsonStatDisplay(stack -> header, stack -> description, readerHelper, min, max);
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<T> currentList(ItemStack original, ItemStack compareTo) {
        List<T> guis = this.getGuis(original);
        guis.addAll(this.getGuis(compareTo));
        return guis;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<T> getGuis(final ItemStack itemStack) {
        ArrayList guis = new ArrayList();
        JsonElement element = ItemModule.getModules(itemStack).getPropertiesMerged().get(this);
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(guiElement -> {
                String type;
                JsonObject object;
                if (guiElement instanceof JsonObject && (object = (JsonObject)guiElement).has("type") && StatListWidget.jsonConverterMap.containsKey(type = object.get("type").getAsString())) {
                    final double getValue = this.getOrDefault(object, "default", 0.0);
                    guis.add(StatListWidget.jsonConverterMap.get(type).fromJson((JsonElement)guiElement, new SingleStatDisplayDouble.StatReaderHelper(){

                        @Override
                        public double getValue(ItemStack testStack) {
                            if (itemStack.equals(testStack)) {
                                return getValue;
                            }
                            return 0.0;
                        }

                        @Override
                        public boolean hasValue(ItemStack testStack) {
                            return itemStack.equals(testStack);
                        }
                    }));
                }
            });
        }
        return guis;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    public double getOrDefault(JsonObject element, String key, double fallback) {
        if (element.has(key) && element.get(key).isJsonPrimitive()) {
            return element.get(key).getAsDouble();
        }
        return fallback;
    }
}

