/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Environment;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GuiStatProperty
implements ModuleProperty {
    public static String KEY = "gui_stat";
    public static GuiStatProperty property;

    public GuiStatProperty() {
        property = this;
        if (Environment.isClient()) {
            ModularItemCache.setSupplier(KEY, GuiStatProperty::getInfoCache);
            StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

                @Override
                public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                    ArrayList combined = new ArrayList();
                    Map<String, GuiInfo> combinedMap = GuiStatProperty.getInfo(original);
                    combinedMap.putAll(GuiStatProperty.getInfo(compareTo));
                    combinedMap.forEach((key, gui) -> {
                        JsonStatDisplay display = new JsonStatDisplay(itemStack -> gui.header, itemStack -> gui.description, new SingleStatDisplayDouble.StatReaderHelper(){
                            final /* synthetic */ String val$key;
                            {
                                this.val$key = string;
                            }

                            @Override
                            public double getValue(ItemStack itemStack) {
                                return GuiStatProperty.getValue(itemStack, this.val$key);
                            }

                            @Override
                            public boolean hasValue(ItemStack itemStack) {
                                return GuiStatProperty.getValue(itemStack, this.val$key) != 0.0;
                            }
                        }, gui.min, gui.max);
                        combined.add(display);
                    });
                    return combined;
                }
            });
        }
    }

    private static Map<String, GuiInfo> getInfoCache(ItemStack itemStack) {
        HashMap<String, GuiInfo> infoMap = new HashMap<String, GuiInfo>();
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            if (!moduleInstance.getProperties().containsKey(property)) continue;
            JsonElement element = moduleInstance.getProperties().get(property);
            element.getAsJsonObject().asMap().forEach((id, innerJson) -> infoMap.put((String)id, new GuiInfo(innerJson.getAsJsonObject(), moduleInstance)));
        }
        return infoMap;
    }

    public static Map<String, GuiInfo> getInfo(ItemStack itemStack) {
        return ModularItemCache.getVisualOnlyCache(itemStack, KEY, new HashMap());
    }

    public static double getValue(ItemStack itemStack, String key) {
        Map<String, GuiInfo> infoMap = GuiStatProperty.getInfoCache(itemStack);
        if (infoMap.containsKey(key)) {
            return infoMap.get((Object)key).value;
        }
        return 0.0;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        return ModuleProperty.mergeAsMap(old, toMerge, type);
    }

    public static class GuiInfo {
        public double min;
        public double max;
        public double value;
        public Component header;
        public Component description;

        public GuiInfo(JsonObject json, ItemModule.ModuleInstance moduleInstance) {
            this.min = ModuleProperty.getDouble(json, "min", moduleInstance, 0.0);
            this.max = ModuleProperty.getDouble(json, "max", moduleInstance, 3.0);
            this.value = ModuleProperty.getDouble(json, "value", moduleInstance, 0.0);
            this.header = ModuleProperty.getText(json, "header", moduleInstance, (Component)Component.m_237119_());
            this.description = ModuleProperty.getText(json, "description", moduleInstance, (Component)Component.m_237119_());
        }
    }
}

