/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.statdisplay.JsonStatDisplay;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.item.FakeEnchantment;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class FakeEnchantmentProperty
implements ModuleProperty {
    public static FakeEnchantmentProperty property;
    public static final String KEY = "fake_enchant";
    private static final Type type;

    public FakeEnchantmentProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, FakeEnchantmentProperty::getEnchantsCache);
        FakeEnchantment.enchantmentTransformers.add((enchantment, stack, level) -> {
            if (FakeEnchantmentProperty.getEnchants(stack).containsKey(enchantment)) {
                return Math.max(FakeEnchantmentProperty.getEnchants(stack).get(enchantment), level);
            }
            return level;
        });
        if (Environment.isClient()) {
            this.setupClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupClient() {
        StatListWidget.addStatDisplaySupplier(new StatListWidget.StatWidgetSupplier(){

            @Override
            public <T extends InteractAbleWidget> List<T> currentList(ItemStack original, ItemStack compareTo) {
                ArrayList displays = new ArrayList();
                HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(FakeEnchantmentProperty.getEnchants(original));
                FakeEnchantmentProperty.getEnchants(original).forEach((enchantment, integer) -> {
                    if (enchantments.containsKey(enchantment)) {
                        enchantments.put((Enchantment)enchantment, Math.max(integer, (Integer)enchantments.get(enchantment)));
                    }
                    enchantments.put((Enchantment)enchantment, (Integer)integer);
                });
                enchantments.keySet().forEach(enchantment -> {
                    JsonStatDisplay display = new JsonStatDisplay(stack -> Component.m_237115_((String)enchantment.m_44704_()), stack -> Component.m_237115_((String)enchantment.m_44704_()), new SingleStatDisplayDouble.StatReaderHelper(){
                        final /* synthetic */ Enchantment val$enchantment;
                        {
                            this.val$enchantment = enchantment;
                        }

                        @Override
                        public double getValue(ItemStack itemStack) {
                            return EnchantmentHelper.m_44843_((Enchantment)this.val$enchantment, (ItemStack)itemStack);
                        }

                        @Override
                        public boolean hasValue(ItemStack itemStack) {
                            return true;
                        }
                    }, 0.0, enchantment.m_6586_());
                    if (enchantment.m_6589_()) {
                        display.inverse = true;
                    }
                    displays.add(display);
                });
                return displays;
            }
        });
    }

    private static Map<Enchantment, Integer> getEnchantsCache(ItemStack itemStack) {
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        JsonElement list = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property, MergeType.SMART);
        ItemModule.getMergedProperty(ItemModule.getModules(itemStack), (ModuleProperty)property);
        Map map = (Map)Miapi.gson.fromJson(list, type);
        if (map != null) {
            map.forEach((id, level) -> {
                Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(id));
                if (enchantment != null && enchantment.m_6081_(itemStack)) {
                    enchants.put(enchantment, (Integer)level);
                }
            });
        }
        return enchants;
    }

    public static Map<Enchantment, Integer> getEnchants(ItemStack itemStack) {
        return ModularItemCache.get(itemStack, KEY, new HashMap());
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType mergeType) {
        if (old != null && toMerge != null) {
            Map mapOld = (Map)Miapi.gson.fromJson(old, type);
            Map mapToMerge = (Map)Miapi.gson.fromJson(toMerge, type);
            if (mergeType.equals((Object)MergeType.OVERWRITE)) {
                return toMerge;
            }
            mapOld.forEach((key, level) -> {
                if (mapToMerge.containsKey(key)) {
                    mapToMerge.put(key, Math.max((Integer)mapOld.get(key), (Integer)mapToMerge.get(key)));
                } else {
                    mapToMerge.put(key, level);
                }
            });
            return Miapi.gson.toJsonTree((Object)mapToMerge);
        }
        if (old == null && toMerge != null) {
            return toMerge;
        }
        return old;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Miapi.gson.fromJson(data, type);
        return true;
    }

    static {
        type = new TypeToken<Map<String, Integer>>(){}.getType();
    }
}

