/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import dev.architectury.event.EventResult;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.CodecBasedProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ExplosionProperty
extends CodecBasedProperty<ExplosionInfo> {
    public static final String KEY = "explosion_projectile";
    public static final Codec<ExplosionInfo> codec = AutoCodec.of(ExplosionInfo.class).codec();
    public static ExplosionProperty property;

    public ExplosionProperty() {
        super(KEY, codec);
        property = this;
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            @Nullable Tuple<ItemModule.ModuleInstance, JsonElement> jsonElement = this.highestPriorityJsonElement(event.projectile.m_7941_());
            if (jsonElement != null) {
                ExplosionInfo info = new ExplosionInfo(((JsonElement)jsonElement.m_14419_()).getAsJsonObject(), (ItemModule.ModuleInstance)jsonElement.m_14418_());
                if (!event.projectile.m_9236_().m_5776_()) {
                    ExplosionProperty.explode(info, event.projectile, (HitResult)event.entityHitResult);
                    event.projectile.m_146870_();
                }
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.register(event -> {
            ExplosionInfo info = (ExplosionInfo)this.get(event.projectile.m_7941_());
            if (info != null) {
                if (!event.projectile.m_9236_().m_5776_()) {
                    ExplosionProperty.explode(info, event.projectile, (HitResult)event.blockHitResult);
                    event.projectile.m_146870_();
                }
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
    }

    public static void explode(ExplosionInfo info, ItemProjectileEntity projectile, HitResult result) {
        double x = result.m_82450_().m_7096_();
        double y = result.m_82450_().m_7098_();
        double z = result.m_82450_().m_7094_();
        ArrowExplosionInfo behavior = new ArrowExplosionInfo();
        Explosion.BlockInteraction destructionType = info.destroyBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        MiapiExplosion explosion = new MiapiExplosion(projectile.m_9236_(), (Entity)(projectile.m_19749_() == null ? projectile : projectile.m_19749_()), null, behavior, x, y, z, (float)info.strength, false, destructionType);
        explosion.entityMaxDamage = (float)info.entityMaxDamage;
        explosion.entityRadius = (float)info.entityRadius;
        explosion.entityExplosionPower = (float)info.entityStrength;
        if (!projectile.m_9236_().f_46443_) {
            explosion.m_46061_();
        }
        explosion.m_46075_(true);
        if (!projectile.m_9236_().m_5776_()) {
            if (!explosion.m_254884_()) {
                explosion.m_46080_();
            }
            for (ServerPlayer serverPlayerEntity : projectile.m_9236_().m_6907_()) {
                if (!(serverPlayerEntity.m_20275_(x, y, z) < 4096.0)) continue;
                serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, (float)info.strength, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayerEntity)));
            }
        }
    }

    public ExplosionInfo getInfo(ItemStack itemStack, ModuleProperty property) {
        ExplosionInfo info = null;
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            if (!moduleInstance.getProperties().containsKey(property)) continue;
            info = new ExplosionInfo(moduleInstance.getProperties().get(property).getAsJsonObject(), moduleInstance);
        }
        return info;
    }

    public static void explode(ExplosionInfo info, Level world, Vec3 vec3d, @Nullable Entity owner) {
        double x = vec3d.m_7096_();
        double y = vec3d.m_7098_();
        double z = vec3d.m_7094_();
        ArrowExplosionInfo behavior = new ArrowExplosionInfo();
        Explosion.BlockInteraction destructionType = info.destroyBlocks ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        MiapiExplosion explosion = new MiapiExplosion(world, owner, null, behavior, x, y, z, (float)info.strength, false, destructionType);
        explosion.entityMaxDamage = (float)info.entityMaxDamage;
        explosion.entityRadius = (float)info.entityRadius;
        explosion.entityExplosionPower = (float)info.entityStrength;
        if (!world.f_46443_) {
            explosion.m_46061_();
        }
        explosion.m_46075_(true);
        if (!world.m_5776_()) {
            if (!explosion.m_254884_()) {
                explosion.m_46080_();
            }
            for (ServerPlayer serverPlayerEntity : world.m_6907_()) {
                if (!(serverPlayerEntity.m_20275_(x, y, z) < 4096.0)) continue;
                serverPlayerEntity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, (float)info.strength, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayerEntity)));
            }
        }
    }

    public static class ArrowExplosionInfo
    extends ExplosionDamageCalculator {
        public Optional<Float> m_6617_(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState) {
            Optional<Float> distance;
            Optional<Float> optional = distance = blockState.m_60795_() && fluidState.m_76178_() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(blockState.m_60734_().m_7325_(), fluidState.m_76190_())));
            if (distance.isPresent()) {
                // empty if block
            }
            return distance;
        }
    }

    public static class ExplosionInfo {
        @CodecBehavior.Optional
        public boolean destroyBlocks;
        @CodecBehavior.Optional
        public double chance;
        public double strength;
        @CodecBehavior.Optional
        public double entityStrength;
        @CodecBehavior.Optional
        public double entityMaxDamage;
        @CodecBehavior.Optional
        public double entityRadius;

        public ExplosionInfo(JsonObject element, ItemModule.ModuleInstance moduleInstance) {
            this.destroyBlocks = ModuleProperty.getBoolean(element, "destroyBlocks", false);
            this.chance = ModuleProperty.getDouble(element, "chance", moduleInstance, 1.0);
            this.strength = ModuleProperty.getDouble(element, "strength", moduleInstance, 1.0);
            this.entityStrength = ModuleProperty.getDouble(element, "entityStrength", moduleInstance, this.strength * 7.0);
            this.entityMaxDamage = ModuleProperty.getDouble(element, "entityMaxDamage", moduleInstance, Double.POSITIVE_INFINITY);
            this.entityRadius = ModuleProperty.getDouble(element, "entityRadius", moduleInstance, this.strength * 2.0);
        }

        public ExplosionInfo() {
        }
    }

    public static class MiapiExplosion
    extends Explosion {
        private static final ExplosionDamageCalculator DEFAULT_BEHAVIOR = new ExplosionDamageCalculator();
        public float blockExplosionPower;
        public float entityExplosionPower;
        public float entityRadius;
        public float entityMaxDamage;
        private Level world;
        private final double explosionX;
        private final double explosionY;
        private final double explosionZ;
        private final ExplosionDamageCalculator behavior;

        public MiapiExplosion(Level world, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x, double y, double z, float power, boolean createFire, Explosion.BlockInteraction destructionType) {
            super(world, entity, damageSource, behavior, x, y, z, power, createFire, destructionType);
            this.world = world;
            this.explosionX = x;
            this.explosionY = y;
            this.explosionZ = z;
            this.behavior = behavior == null ? this.chooseBehavior(entity) : behavior;
            this.blockExplosionPower = power;
            this.entityExplosionPower = power * 7.0f;
            this.entityRadius = power * 2.0f;
            this.entityMaxDamage = Float.POSITIVE_INFINITY;
        }

        private ExplosionDamageCalculator chooseBehavior(@Nullable Entity entity) {
            return entity == null ? DEFAULT_BEHAVIOR : new EntityBasedExplosionDamageCalculator(entity);
        }

        public void m_46061_() {
            this.world.m_220400_(this.f_46016_, GameEvent.f_157812_, new Vec3(this.explosionX, this.explosionY, this.explosionZ));
            HashSet affectedBlockPositions = Sets.newHashSet();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    block2: for (int z = 0; z < 16; ++z) {
                        if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                        double offsetX = (double)x / 15.0 * 2.0 - 1.0;
                        double offsetY = (double)y / 15.0 * 2.0 - 1.0;
                        double offsetZ = (double)z / 15.0 * 2.0 - 1.0;
                        double distance = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
                        offsetX /= distance;
                        offsetY /= distance;
                        offsetZ /= distance;
                        double currentX = this.explosionX;
                        double currentY = this.explosionY;
                        double currentZ = this.explosionZ;
                        for (float explosionPower = this.blockExplosionPower * (0.7f + this.world.f_46441_.m_188501_() * 0.6f); explosionPower > 0.0f; explosionPower -= 0.22500001f) {
                            BlockPos blockPos = BlockPos.m_274561_((double)currentX, (double)currentY, (double)currentZ);
                            BlockState blockState = this.world.m_8055_(blockPos);
                            FluidState fluidState = this.world.m_6425_(blockPos);
                            if (!this.world.m_46739_(blockPos)) continue block2;
                            Optional resistance = this.behavior.m_6617_((Explosion)this, (BlockGetter)this.world, blockPos, blockState, fluidState);
                            if (resistance.isPresent()) {
                                explosionPower -= (((Float)resistance.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (explosionPower > 0.0f && this.behavior.m_6714_((Explosion)this, (BlockGetter)this.world, blockPos, blockState, explosionPower)) {
                                affectedBlockPositions.add(blockPos);
                            }
                            currentX += offsetX * (double)0.3f;
                            currentY += offsetY * (double)0.3f;
                            currentZ += offsetZ * (double)0.3f;
                        }
                    }
                }
            }
            this.m_46081_().addAll(affectedBlockPositions);
            int minX = Mth.m_14107_((double)(this.explosionX - (double)this.entityRadius - 1.0));
            int maxX = Mth.m_14107_((double)(this.explosionX + (double)this.entityRadius + 1.0));
            int minY = Mth.m_14107_((double)(this.explosionY - (double)this.entityRadius - 1.0));
            int maxY = Mth.m_14107_((double)(this.explosionY + (double)this.entityRadius + 1.0));
            int minZ = Mth.m_14107_((double)(this.explosionZ - (double)this.entityRadius - 1.0));
            int maxZ = Mth.m_14107_((double)(this.explosionZ + (double)this.entityRadius + 1.0));
            List nearbyEntities = this.world.m_45933_(this.f_46016_, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
            nearbyEntities.add(this.f_46016_);
            Vec3 explosionCenter = new Vec3(this.explosionX, this.explosionY, this.explosionZ);
            for (int i = 0; i < nearbyEntities.size(); ++i) {
                Player playerEntity;
                double knockback;
                double deltaZ;
                double deltaY;
                double deltaX;
                double entityDistance;
                double distanceToCenter;
                Entity targetEntity = (Entity)nearbyEntities.get(i);
                if (targetEntity.m_6128_() || !((distanceToCenter = Math.sqrt(targetEntity.m_20238_(explosionCenter)) / (double)this.entityRadius) <= 1.0) || (entityDistance = Math.sqrt((deltaX = targetEntity.m_20185_() - this.explosionX) * deltaX + (deltaY = (targetEntity instanceof PrimedTnt ? targetEntity.m_20186_() : targetEntity.m_20188_()) - this.explosionY) * deltaY + (deltaZ = targetEntity.m_20189_() - this.explosionZ) * deltaZ)) == 0.0) continue;
                deltaX /= entityDistance;
                deltaY /= entityDistance;
                deltaZ /= entityDistance;
                double exposure = MiapiExplosion.m_46064_((Vec3)explosionCenter, (Entity)targetEntity);
                double damage = (1.0 - distanceToCenter) * exposure;
                float totalDamage = Math.min(this.entityMaxDamage, (float)((int)((damage * damage + damage) / 2.0 * (double)this.entityExplosionPower + 1.0)));
                targetEntity.m_6469_(this.m_46077_(), totalDamage);
                if (targetEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)targetEntity;
                    knockback = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)damage);
                } else {
                    knockback = damage;
                }
                Vec3 velocity = new Vec3(deltaX *= knockback, deltaY *= knockback, deltaZ *= knockback);
                targetEntity.m_20256_(targetEntity.m_20184_().m_82549_(velocity));
                if (!(targetEntity instanceof Player) || (playerEntity = (Player)targetEntity).m_5833_() || playerEntity.m_7500_() && playerEntity.m_150110_().f_35935_) continue;
                this.m_46078_().put(playerEntity, velocity);
            }
        }
    }
}

