/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class EdibleProperty
implements ModuleProperty {
    public static final String KEY = "edible";
    public static EdibleProperty property;

    public EdibleProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, EdibleProperty::createCache);
    }

    public static Holder get(ItemStack itemStack) {
        return (Holder)ModularItemCache.getRaw(itemStack, KEY);
    }

    public static Holder createCache(ItemStack stack) {
        Holder result = new Holder(0, 0.0, 1.0, 0.0, false, new ArrayList<MobEffectInstance>());
        for (ItemModule.ModuleInstance subModule : ItemModule.getModules(stack).allSubModules()) {
            JsonElement element = subModule.getProperties().get(property);
            if (element == null) continue;
            Holder holder = ((RawData)RawData.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to decode using codec during cache creation for a CodecBasedProperty! -> " + s))).toHolder(subModule);
            result.hunger += holder.hunger;
            result.saturation += holder.saturation;
            result.eatingSpeed *= holder.eatingSpeed;
            result.effects.addAll(holder.effects);
            result.durabilityDamage += holder.durabilityDamage;
            if (!holder.alwaysEdible) continue;
            result.alwaysEdible = true;
        }
        return result;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        RawData.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, s -> {
            Miapi.LOGGER.error("Failed to parse data for edible property for module with key '{}'! -> {}", (Object)moduleKey, s);
            throw new RuntimeException();
        });
        return true;
    }

    @Override
    public JsonElement merge(JsonElement oldEl, JsonElement toMergeEl, MergeType type) {
        if (type == MergeType.OVERWRITE) {
            return toMergeEl.deepCopy();
        }
        JsonObject newElement = new JsonObject();
        JsonObject old = oldEl.getAsJsonObject();
        JsonObject toMerge = toMergeEl.getAsJsonObject();
        newElement.addProperty("hunger", JsonUtil.getOrElse((JsonObject)old, (String)"hunger", (String)"0") + "+" + JsonUtil.getOrElse((JsonObject)toMerge, (String)"hunger", (String)"0"));
        newElement.addProperty("saturation", JsonUtil.getOrElse((JsonObject)old, (String)"saturation", (String)"0") + "+" + JsonUtil.getOrElse((JsonObject)toMerge, (String)"saturation", (String)"0"));
        newElement.addProperty("eatingSpeed", JsonUtil.getOrElse((JsonObject)old, (String)"eatingSpeed", (String)"0") + "+" + JsonUtil.getOrElse((JsonObject)toMerge, (String)"eatingSpeed", (String)"0"));
        JsonElement oldEdibility = old.get("alwaysEdible");
        JsonElement toMergeEdibility = toMerge.get("alwaysEdible");
        newElement.addProperty("alwaysEdible", Boolean.valueOf(oldEdibility != null && oldEdibility.getAsBoolean() || toMergeEdibility != null && toMergeEdibility.getAsBoolean()));
        JsonElement oldEffects = old.get("effects");
        JsonElement toMergeEffects = toMerge.get("effects");
        JsonArray newEffects = new JsonArray();
        if (oldEffects != null) {
            newEffects.addAll(oldEffects.getAsJsonArray());
        }
        if (toMergeEffects != null) {
            newEffects.addAll(toMergeEffects.getAsJsonArray());
        }
        newElement.add("effects", (JsonElement)newEffects);
        return newElement;
    }

    public static final class Holder {
        public int hunger;
        public double saturation;
        public double eatingSpeed;
        public double durabilityDamage;
        public boolean alwaysEdible;
        public List<MobEffectInstance> effects;

        public Holder(int hunger, double saturation, double eatingSpeed, double durabilityDamage, boolean alwaysEdible, List<MobEffectInstance> effects) {
            this.hunger = hunger;
            this.durabilityDamage = durabilityDamage;
            this.saturation = saturation;
            this.eatingSpeed = eatingSpeed;
            this.alwaysEdible = alwaysEdible;
            this.effects = effects;
        }

        public void finishedEat(ItemStack itemStack, RandomSource random, ServerPlayer serverPlayerEntity) {
            if (this.durabilityDamage == 0.0) {
                itemStack.m_41774_(1);
            } else {
                itemStack.m_220157_((int)this.durabilityDamage, random, serverPlayerEntity);
            }
        }
    }

    public static class RawData {
        public static final Codec<RawData> codec = AutoCodec.of(RawData.class).codec();
        public StatResolver.IntegerFromStat hunger;
        public StatResolver.DoubleFromStat saturation;
        @CodecBehavior.Optional
        public StatResolver.DoubleFromStat durability = new StatResolver.DoubleFromStat(0.0);
        @CodecBehavior.Optional
        public StatResolver.DoubleFromStat eatingSpeed = new StatResolver.DoubleFromStat(1.0);
        @CodecBehavior.Optional
        public boolean alwaysEdible = false;
        @CodecBehavior.Optional
        public List<StatusEffectHolder> effects = new ArrayList<StatusEffectHolder>();

        public Holder toHolder(ItemModule.ModuleInstance instance) {
            return new Holder((Integer)this.hunger.evaluate(instance), (Double)this.saturation.evaluate(instance), (Double)this.eatingSpeed.evaluate(instance), (Double)this.durability.evaluate(instance), this.alwaysEdible, this.effects.stream().map(e -> new MobEffectInstance(e.effect, e.duration, e.amplifier, e.ambient, e.showParticles, e.showIcon)).toList());
        }
    }

    @CodecBehavior.Override(value="codec")
    @AutoCodec.Settings(defaultOptionalBehavior=@CodecBehavior.Optional)
    public static class StatusEffectHolder {
        public static final Codec<StatusEffectHolder> codec = AutoCodec.of(StatusEffectHolder.class).codec();
        @CodecBehavior.Optional(value=false)
        public MobEffect effect;
        @CodecBehavior.Optional(value=false)
        public int duration;
        @CodecBehavior.Optional(value=false)
        public int amplifier;
        public boolean ambient = false;
        public boolean showParticles = true;
        public boolean showIcon = true;
    }
}

