/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CraftingEnchantProperty
implements ModuleProperty,
CraftingProperty {
    public static final String KEY = "crafting_enchants";
    public static CraftingEnchantProperty property;
    private static final Type type;

    public CraftingEnchantProperty() {
        property = this;
        MiapiEvents.SMITHING_EVENT.register(listener -> {
            listener.itemStack = this.applyEnchants(listener.itemStack);
            return EventResult.pass();
        });
    }

    private static List<Pair<Enchantment, Integer>> getEnchantsCache(ItemStack itemStack) {
        ArrayList<Pair<Enchantment, Integer>> enchants = new ArrayList<Pair<Enchantment, Integer>>();
        JsonElement list = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property, MergeType.SMART);
        ItemModule.getMergedProperty(ItemModule.getModules(itemStack), (ModuleProperty)property);
        Map map = (Map)Miapi.gson.fromJson(list, type);
        if (map != null) {
            map.forEach((id, level) -> {
                Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(id));
                if (enchantment != null && enchantment.m_6081_(itemStack)) {
                    enchants.add(new Pair((Object)enchantment, level));
                }
            });
        }
        return enchants;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType mergeType) {
        if (old != null && toMerge != null) {
            Map mapOld = (Map)Miapi.gson.fromJson(old, type);
            Map mapToMerge = (Map)Miapi.gson.fromJson(toMerge, type);
            if (mergeType.equals((Object)MergeType.OVERWRITE)) {
                return toMerge;
            }
            mapOld.forEach((key, level) -> {
                if (mapToMerge.containsKey(key)) {
                    mapToMerge.put(key, Math.max((Integer)mapOld.get(key), (Integer)mapToMerge.get(key)));
                } else {
                    mapToMerge.put(key, level);
                }
            });
            return Miapi.gson.toJsonTree((Object)mapToMerge);
        }
        if (old == null && toMerge != null) {
            return toMerge;
        }
        return old;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Miapi.gson.fromJson(data, type);
        return true;
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ItemModule.ModuleInstance module, ItemModule.ModuleInstance root, ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        return this.applyEnchants(crafting);
    }

    public ItemStack applyEnchants(ItemStack crafting) {
        CraftingEnchantProperty.getEnchantsCache(crafting).forEach(enchantmentIntegerPair -> {
            int prevLevel;
            Enchantment enchantment = (Enchantment)enchantmentIntegerPair.getFirst();
            int level = (Integer)enchantmentIntegerPair.getSecond();
            if (enchantment.m_6081_(crafting) && level > (prevLevel = EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)crafting))) {
                if (prevLevel > 0) {
                    CraftingEnchantProperty.removeEnchant(enchantment, crafting);
                }
                crafting.m_41663_(enchantment, level);
            }
        });
        return crafting;
    }

    public static int removeEnchant(Enchantment enchantment, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        ResourceLocation identifier = EnchantmentHelper.m_182432_((Enchantment)enchantment);
        ListTag nbtList = stack.m_41785_();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            ResourceLocation identifier2 = EnchantmentHelper.m_182446_((CompoundTag)nbtCompound);
            if (identifier2 == null || !identifier2.equals((Object)identifier)) continue;
            nbtList.remove((Object)nbtCompound);
        }
        return 0;
    }

    static {
        type = new TypeToken<Map<String, Integer>>(){}.getType();
    }
}

