/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.event.EventResult;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.item.modular.items.ExampleModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.EquipmentSlotProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class AttributeProperty
implements ModuleProperty {
    public static final String KEY = "attributes";
    public static ModuleProperty property;
    public static final Map<String, Supplier<Attribute>> replaceMap;
    public static final Map<Attribute, Float> priorityMap;
    public static final List<AttributeTransformer> attributeTransformers;
    public static Map<EquipmentSlot, UUID> uuidCache;
    public static Map<EquipmentSlot, Map<AttributeModifier.Operation, UUID>> slotCacheLookUP;

    public AttributeProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, AttributeProperty::createAttributeCache);
        ModularItemCache.setSupplier("attributes_unmodifieable", AttributeProperty::equipmentSlotMultimapMapGenerate);
        priorityMap.put(Attributes.f_22284_, Float.valueOf(-15.0f));
        priorityMap.put(Attributes.f_22285_, Float.valueOf(-14.0f));
        priorityMap.put(Attributes.f_22278_, Float.valueOf(-13.0f));
        priorityMap.put(Attributes.f_22281_, Float.valueOf(-12.0f));
        priorityMap.put(AttributeRegistry.MAGIC_DAMAGE, Float.valueOf(-11.5f));
        priorityMap.put(Attributes.f_22283_, Float.valueOf(-11.0f));
        priorityMap.put(AttributeRegistry.CRITICAL_DAMAGE, Float.valueOf(-10.9f));
        priorityMap.put(AttributeRegistry.CRITICAL_CHANCE, Float.valueOf(-10.8f));
        priorityMap.put(AttributeRegistry.PROJECTILE_DAMAGE, Float.valueOf(-10.0f));
        priorityMap.put(AttributeRegistry.PROJECTILE_CRIT_MULTIPLIER, Float.valueOf(-9.5f));
        priorityMap.put(AttributeRegistry.PROJECTILE_SPEED, Float.valueOf(-9.0f));
        priorityMap.put(AttributeRegistry.PROJECTILE_ACCURACY, Float.valueOf(-9.0f));
        priorityMap.put(AttributeRegistry.PROJECTILE_PIERCING, Float.valueOf(-9.0f));
        priorityMap.put(AttributeRegistry.MINING_SPEED_AXE, Float.valueOf(-8.0f));
        priorityMap.put(AttributeRegistry.MINING_SPEED_PICKAXE, Float.valueOf(-8.0f));
        priorityMap.put(AttributeRegistry.MINING_SPEED_HOE, Float.valueOf(-8.0f));
        priorityMap.put(AttributeRegistry.MINING_SPEED_SHOVEL, Float.valueOf(-8.0f));
        priorityMap.put(AttributeRegistry.REACH, Float.valueOf(-7.0f));
        priorityMap.put(AttributeRegistry.ATTACK_RANGE, Float.valueOf(-7.0f));
        priorityMap.put(AttributeRegistry.BACK_STAB, Float.valueOf(-6.0f));
        priorityMap.put(AttributeRegistry.SHIELD_BREAK, Float.valueOf(-6.0f));
        priorityMap.put(AttributeRegistry.ARMOR_CRUSHING, Float.valueOf(-6.0f));
        MiapiEvents.ITEM_STACK_ATTRIBUTE_EVENT.register(info -> {
            info.attributeModifiers.putAll(AttributeProperty.equipmentSlotMultimapMap(info.itemStack).get(info.equipmentSlot));
            return EventResult.pass();
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement element) throws Exception {
        ArrayListMultimap attributeModifiers = ArrayListMultimap.create();
        for (JsonElement attributeElement : element.getAsJsonArray()) {
            JsonObject attributeJson = attributeElement.getAsJsonObject();
            String attributeName = attributeJson.get("attribute").getAsString();
            double value = StatResolver.resolveDouble(attributeJson.get("value").getAsString(), new ItemModule.ModuleInstance(ItemModule.empty));
            AttributeModifier.Operation operation = AttributeProperty.getOperation(attributeJson.get("operation").getAsString());
            EquipmentSlot slot = AttributeProperty.getSlot(attributeJson.get("slot").getAsString());
            Attribute attribute = replaceMap.getOrDefault(attributeName, () -> (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeName))).get();
            UUID uuid = null;
            if (attributeJson.has("uuid")) {
                uuid = UUID.fromString(attributeJson.get("uuid").getAsString());
            }
            String modifierName = attributeName;
            if (attributeJson.has("name")) {
                modifierName = attributeJson.get("name").getAsString();
            }
            AttributeModifier.Operation targetOperation = AttributeModifier.Operation.ADDITION;
            if (attributeJson.has("target_operation")) {
                targetOperation = AttributeProperty.getOperation(attributeJson.get("target_operation").getAsString());
            }
            if (attribute == null) continue;
            if (uuid != null) {
                attributeModifiers.put((Object)attribute, (Object)new EntityAttributeModifierHolder(new AttributeModifier(uuid, modifierName, value, operation), slot, true, targetOperation));
                continue;
            }
            attributeModifiers.put((Object)attribute, (Object)new EntityAttributeModifierHolder(new AttributeModifier(modifierName, value, operation), slot, true, targetOperation));
        }
        return true;
    }

    public static Multimap<Attribute, AttributeModifier> mergeAttributes(Multimap<Attribute, AttributeModifier> old, Multimap<Attribute, AttributeModifier> into) {
        LinkedListMultimap mergedList = LinkedListMultimap.create();
        old.entries().forEach(arg_0 -> AttributeProperty.lambda$mergeAttributes$2((Multimap)mergedList, arg_0));
        into.entries().forEach(arg_0 -> AttributeProperty.lambda$mergeAttributes$3((Multimap)mergedList, arg_0));
        return mergedList;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case SMART: 
            case EXTEND: {
                JsonElement element = old.deepCopy();
                element.getAsJsonArray().addAll(toMerge.getAsJsonArray());
                return element;
            }
            case OVERWRITE: {
                return toMerge;
            }
        }
        return old;
    }

    public static Multimap<Attribute, EntityAttributeModifierHolder> getAttributeModifiers(ItemStack itemStack) {
        ArrayListMultimap map = AttributeProperty.getAttributeModifiersRaw(itemStack);
        ArrayListMultimap map2 = ArrayListMultimap.create();
        map.entries().forEach(arg_0 -> AttributeProperty.lambda$getAttributeModifiers$4((Multimap)map2, arg_0));
        map = map2;
        for (AttributeTransformer transformer : attributeTransformers) {
            ArrayListMultimap map3 = ArrayListMultimap.create();
            transformer.transform((Multimap<Attribute, EntityAttributeModifierHolder>)map, itemStack).entries().forEach(arg_0 -> AttributeProperty.lambda$getAttributeModifiers$5((Multimap)map3, arg_0));
            map = map3;
        }
        return map;
    }

    public static Multimap<Attribute, EntityAttributeModifierHolder> getAttributeModifiersRaw(ItemStack itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        return (Multimap)ModularItemCache.get(itemStack, KEY, multimap);
    }

    private static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> equipmentSlotMultimapMapGenerate(ItemStack itemStack) {
        HashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>> map = new HashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
        Arrays.stream(EquipmentSlot.values()).forEach(equipmentSlot -> map.put((EquipmentSlot)equipmentSlot, (Multimap<Attribute, AttributeModifier>)Multimaps.unmodifiableMultimap(AttributeProperty.getAttributeModifiersForSlot(itemStack, equipmentSlot, (Multimap<Attribute, AttributeModifier>)ArrayListMultimap.create()))));
        return map;
    }

    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> equipmentSlotMultimapMap(ItemStack itemStack) {
        EnumMap<EquipmentSlot, ArrayListMultimap> replaceMap = new EnumMap<EquipmentSlot, ArrayListMultimap>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            replaceMap.put(slot, ArrayListMultimap.create());
        }
        return ModularItemCache.get(itemStack, "attributes_unmodifieable", replaceMap);
    }

    private static Multimap<Attribute, AttributeModifier> getAttributeModifiersForSlot(ItemStack itemStack, EquipmentSlot slot, Multimap<Attribute, AttributeModifier> toAdding) {
        if (itemStack.m_41720_() instanceof ModularItem) {
            Multimap<Attribute, EntityAttributeModifierHolder> toMerge = AttributeProperty.getAttributeModifiers(itemStack);
            ArrayListMultimap merged = ArrayListMultimap.create();
            HashMap<UUID, Multimap> mergedAdditive = new HashMap<UUID, Multimap>();
            HashMap<UUID, Multimap> mergedMultiBase = new HashMap<UUID, Multimap>();
            HashMap<UUID, Multimap> mergedMultiTotal = new HashMap<UUID, Multimap>();
            toAdding.entries().forEach(arg_0 -> AttributeProperty.lambda$getAttributeModifiersForSlot$7((Multimap)merged, arg_0));
            toMerge.forEach((arg_0, arg_1) -> AttributeProperty.lambda$getAttributeModifiersForSlot$11(slot, (Multimap)merged, mergedAdditive, mergedMultiBase, mergedMultiTotal, arg_0, arg_1));
            toAdding.clear();
            toAdding.putAll((Multimap)merged);
            mergedAdditive.forEach((uuid, entityAttributeEntityAttributeModifierMultimap) -> entityAttributeEntityAttributeModifierMultimap.asMap().forEach((key, collection) -> {
                double startValue = key.m_22082_();
                double multiply = 1.0;
                boolean hasValue = false;
                for (AttributeModifier entityAttributeModifier : collection) {
                    if (entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) {
                        startValue += entityAttributeModifier.m_22218_();
                        hasValue = true;
                    }
                    if (!entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)) continue;
                    multiply += entityAttributeModifier.m_22218_();
                }
                startValue *= multiply;
                for (AttributeModifier entityAttributeModifier : collection) {
                    if (!entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)) continue;
                    startValue *= entityAttributeModifier.m_22218_();
                }
                if (((startValue -= key.m_22082_()) != 0.0 || hasValue) && !Double.isNaN(startValue)) {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(uuid, "generic.miapi." + key.m_22087_(), startValue, AttributeModifier.Operation.ADDITION);
                    toAdding.put(key, (Object)entityAttributeModifier);
                }
            }));
            mergedMultiBase.forEach((uuid, entityAttributeEntityAttributeModifierMultimap) -> entityAttributeEntityAttributeModifierMultimap.asMap().forEach((key, collection) -> {
                double multiply = 0.0;
                for (AttributeModifier entityAttributeModifier : collection) {
                    if (entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_BASE)) {
                        multiply += entityAttributeModifier.m_22218_();
                    }
                    if (!entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) continue;
                    Miapi.LOGGER.warn("Operation Addition(+) is not supported to be merged to Multiply Base(*)");
                }
                for (AttributeModifier entityAttributeModifier : collection) {
                    if (!entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)) continue;
                    multiply = (multiply + 1.0) * (entityAttributeModifier.m_22218_() + 1.0) - 1.0;
                }
                if (!Double.isNaN(multiply)) {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(uuid, "generic.miapi." + key.m_22087_(), multiply, AttributeModifier.Operation.MULTIPLY_BASE);
                    toAdding.put(key, (Object)entityAttributeModifier);
                }
            }));
            mergedMultiTotal.forEach((uuid, entityAttributeEntityAttributeModifierMultimap) -> entityAttributeEntityAttributeModifierMultimap.asMap().forEach((key, collection) -> {
                double multiply = 1.0;
                for (AttributeModifier entityAttributeModifier : collection) {
                    if (entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                        multiply *= entityAttributeModifier.m_22218_();
                    }
                    if (entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) {
                        Miapi.LOGGER.warn("Operation Addition(+) is not supported to be merged to Multiply Total(**)");
                    }
                    if (!entityAttributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) continue;
                    Miapi.LOGGER.warn("Operation Multiply Base(*) is not supported to be merged to Multiply Total(**)");
                }
                if (!Double.isNaN(multiply)) {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(uuid, "generic.miapi." + key.m_22087_(), multiply, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    toAdding.put(key, (Object)entityAttributeModifier);
                }
            }));
            return AttributeProperty.sortMultimap(toAdding);
        }
        return toAdding;
    }

    public static Multimap<Attribute, AttributeModifier> sortMultimap(Multimap<Attribute, AttributeModifier> multimap) {
        Comparator comparator = (attribute1, attribute2) -> {
            float priority1 = priorityMap.getOrDefault(attribute1, Float.valueOf(0.0f)).floatValue();
            float priority2 = priorityMap.getOrDefault(attribute2, Float.valueOf(0.0f)).floatValue();
            return Float.compare(priority1, priority2);
        };
        ArrayList sortedKeys = new ArrayList(multimap.keySet());
        sortedKeys.sort(comparator);
        LinkedListMultimap sortedMultimap = LinkedListMultimap.create();
        for (Attribute attribute : sortedKeys) {
            sortedMultimap.putAll((Object)attribute, (Iterable)multimap.get((Object)attribute));
        }
        return sortedMultimap;
    }

    public static double getActualValueFrom(Multimap<Attribute, EntityAttributeModifierHolder> rawMap, EquipmentSlot slot, Attribute entityAttribute, double fallback) {
        ArrayListMultimap map = ArrayListMultimap.create();
        rawMap.forEach((arg_0, arg_1) -> AttributeProperty.lambda$getActualValueFrom$19(slot, (Multimap)map, arg_0, arg_1));
        return AttributeProperty.getActualValue((Multimap<Attribute, AttributeModifier>)map, entityAttribute, fallback);
    }

    public static double getActualValue(ItemStack stack, EquipmentSlot slot, Attribute entityAttribute, double fallback) {
        Collection attributes = stack.m_41638_(slot).get((Object)entityAttribute);
        return AttributeProperty.getActualValue(attributes, fallback);
    }

    public static double getActualValueCache(ItemStack stack, EquipmentSlot slot, Attribute entityAttribute, double fallback) {
        Collection modifiers;
        Multimap<Attribute, AttributeModifier> attributesList = AttributeProperty.equipmentSlotMultimapMap(stack).get(slot);
        if (attributesList != null && (modifiers = attributesList.get((Object)entityAttribute)) != null) {
            return AttributeProperty.getActualValue(modifiers, fallback);
        }
        return fallback;
    }

    public static boolean hasAttribute(Multimap<Attribute, AttributeModifier> map, Attribute entityAttribute, double fallback) {
        Collection attributes = map.get((Object)entityAttribute);
        return !attributes.isEmpty();
    }

    public static double getActualValue(Multimap<Attribute, AttributeModifier> map, Attribute entityAttribute, double fallback) {
        Collection attributes = map.get((Object)entityAttribute);
        return AttributeProperty.getActualValue(attributes, fallback);
    }

    public static double getActualValue(Collection<AttributeModifier> attributes, double fallback) {
        ArrayList addition = new ArrayList();
        ArrayList multiplyBase = new ArrayList();
        ArrayList multiplyTotal = new ArrayList();
        attributes.forEach(attribute -> {
            switch (attribute.m_22217_()) {
                case ADDITION: {
                    addition.add(attribute.m_22218_());
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBase.add(attribute.m_22218_());
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotal.add(attribute.m_22218_());
                }
            }
        });
        double value = fallback;
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = (1.0 + currentValue) * value;
        }
        if (Double.isNaN(value)) {
            return fallback;
        }
        return value;
    }

    public static double getActualValue(ItemStack stack, EquipmentSlot slot, Attribute entityAttribute) {
        return AttributeProperty.getActualValue(stack, slot, entityAttribute, entityAttribute.m_22082_());
    }

    private static Multimap<Attribute, EntityAttributeModifierHolder> createAttributeCache(ItemStack itemStack) {
        return AttributeProperty.createAttributeMap(itemStack, AttributeProperty::getUUIDForSlot);
    }

    public static Multimap<Attribute, EntityAttributeModifierHolder> createAttributeMap(ItemStack itemStack, UUIDGetter defaultUUID) {
        ItemModule.ModuleInstance rootInstance = ItemModule.getModules(itemStack);
        ArrayListMultimap attributeModifiers = ArrayListMultimap.create();
        for (ItemModule.ModuleInstance instance : rootInstance.allSubModules()) {
            AttributeProperty.getAttributeModifiers(defaultUUID, itemStack, instance, (Multimap<Attribute, EntityAttributeModifierHolder>)attributeModifiers);
        }
        return attributeModifiers;
    }

    public static void getAttributeModifiers(UUIDGetter defaultUUID, ItemStack stack, ItemModule.ModuleInstance instance, Multimap<Attribute, EntityAttributeModifierHolder> attributeModifiers) {
        JsonElement element = instance.getProperties().get(property);
        if (element == null) {
            return;
        }
        for (JsonElement attributeElement : element.getAsJsonArray()) {
            UUID uuid;
            AttributeJson attributeJson = (AttributeJson)Miapi.gson.fromJson(attributeElement, AttributeJson.class);
            assert (attributeJson.attribute != null);
            assert (attributeJson.value != null);
            assert (attributeJson.operation != null);
            EquipmentSlot slot = attributeJson.slot != null && attributeJson.slot.equals("item") ? EquipmentSlotProperty.getSlot(stack) : (attributeJson.slot != null ? AttributeProperty.getSlot(attributeJson.slot) : EquipmentSlot.MAINHAND);
            String attributeName = attributeJson.attribute;
            double value = StatResolver.resolveDouble(attributeJson.value, instance);
            AttributeModifier.Operation operation = AttributeProperty.getOperation(attributeJson.operation);
            AttributeModifier.Operation baseTarget = AttributeProperty.getOperation(attributeJson.target_operation);
            Attribute attribute = replaceMap.getOrDefault(attributeName, () -> (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeName))).get();
            if (attribute == null) {
                Miapi.LOGGER.warn(String.valueOf(BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeName))));
                Miapi.LOGGER.warn("Attribute is null " + attributeName + " on module " + instance.module.getName() + " this should not have happened.");
                continue;
            }
            UUID uUID = uuid = attributeJson.uuid == null ? defaultUUID.fromSlot(slot, baseTarget) : UUID.fromString(attributeJson.uuid);
            if (uuid.equals(ExampleModularItem.attackDamageUUID())) {
                uuid = ExampleModularItem.attackDamageUUID();
            }
            if (uuid.equals(ExampleModularItem.attackSpeedUUID())) {
                uuid = ExampleModularItem.attackSpeedUUID();
            }
            attributeModifiers.put((Object)attribute, (Object)new EntityAttributeModifierHolder(new AttributeModifier(uuid, attributeName, value, operation), slot, attributeJson.seperateOnItem, baseTarget));
        }
    }

    public static UUID getUUIDForSlot(EquipmentSlot equipmentSlot) {
        if (uuidCache.containsKey(equipmentSlot)) {
            return uuidCache.get(equipmentSlot);
        }
        String slotidString = equipmentSlot.m_20751_() + "-" + equipmentSlot.m_20749_() + "-" + equipmentSlot.m_20750_();
        return AttributeProperty.getUUIDForSlot(slotidString);
    }

    public static UUID getUUIDForSlot(EquipmentSlot equipmentSlot, AttributeModifier.Operation operation) {
        if (slotCacheLookUP.containsKey(equipmentSlot) && slotCacheLookUP.get(equipmentSlot).containsKey(operation)) {
            return slotCacheLookUP.get(equipmentSlot).get(operation);
        }
        UUID uuid = AttributeProperty.getUUIDForSlot(equipmentSlot, operation, "");
        Map cache = slotCacheLookUP.getOrDefault(equipmentSlot, new HashMap());
        cache.put(operation, uuid);
        slotCacheLookUP.put(equipmentSlot, cache);
        return uuid;
    }

    public static UUID getUUIDForSlot(EquipmentSlot equipmentSlot, AttributeModifier.Operation operation, String context) {
        if (slotCacheLookUP.containsKey(equipmentSlot) && slotCacheLookUP.get(equipmentSlot).containsKey(operation)) {
            return slotCacheLookUP.get(equipmentSlot).get(operation);
        }
        String slotidString = equipmentSlot.m_20751_() + "-" + equipmentSlot.m_20749_() + "-" + equipmentSlot.m_20750_() + "-" + operation.toString() + context;
        return AttributeProperty.getUUIDForSlot(slotidString);
    }

    public static UUID getUUIDForSlot(String slotidString) {
        try {
            int i;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(slotidString.getBytes());
            byte[] hashBytes = md.digest();
            long mostSigBits = 0L;
            long leastSigBits = 0L;
            for (i = 0; i < 8; ++i) {
                mostSigBits = mostSigBits << 8 | (long)(hashBytes[i] & 0xFF);
            }
            for (i = 8; i < 16; ++i) {
                leastSigBits = leastSigBits << 8 | (long)(hashBytes[i] & 0xFF);
            }
            return new UUID(mostSigBits, leastSigBits);
        }
        catch (NoSuchAlgorithmException e) {
            Miapi.LOGGER.warn("could not onReload UUID generator - Attributes are likely to be broken now");
            return UUID.fromString("d3b89c4c-68ff-11ee-8c99-0242ac120002");
        }
    }

    private static AttributeModifier.Operation getOperation(String operationString) {
        if (operationString == null) {
            return AttributeModifier.Operation.ADDITION;
        }
        return switch (operationString) {
            case "*" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "**" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> AttributeModifier.Operation.ADDITION;
        };
    }

    public static EquipmentSlot getSlot(String slotString) {
        if (slotString != null && !slotString.isEmpty()) {
            if (slotString.equals("item")) {
                return EquipmentSlot.MAINHAND;
            }
            try {
                return EquipmentSlot.m_20747_((String)slotString);
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Equipment Slot not found - use correct spelling please [mainhand offhand feet legs chest head]");
                Miapi.LOGGER.error("substituting mainhand Slot Instead");
                e.printStackTrace();
            }
        }
        return EquipmentSlot.MAINHAND;
    }

    private static /* synthetic */ void lambda$getActualValueFrom$19(EquipmentSlot slot, Multimap map, Attribute attribute, EntityAttributeModifierHolder entityAttributeModifierHolder) {
        if (entityAttributeModifierHolder.slot.equals((Object)slot)) {
            map.put((Object)attribute, (Object)entityAttributeModifierHolder.attributeModifier);
        }
    }

    private static /* synthetic */ void lambda$getAttributeModifiersForSlot$11(EquipmentSlot slot, Multimap merged, Map mergedAdditive, Map mergedMultiBase, Map mergedMultiTotal, Attribute entityAttribute, EntityAttributeModifierHolder entityAttributeModifier) {
        if (entityAttributeModifier.slot().equals((Object)slot)) {
            if (entityAttributeModifier.seperateOnItem) {
                merged.put((Object)entityAttribute, (Object)entityAttributeModifier.attributeModifier());
            } else {
                switch (entityAttributeModifier.mergeTo) {
                    case ADDITION: {
                        Multimap multimap = mergedAdditive.computeIfAbsent(entityAttributeModifier.attributeModifier().m_22209_(), id -> ArrayListMultimap.create());
                        multimap.put((Object)entityAttribute, (Object)entityAttributeModifier.attributeModifier());
                        break;
                    }
                    case MULTIPLY_BASE: {
                        Multimap multimap = mergedMultiBase.computeIfAbsent(entityAttributeModifier.attributeModifier().m_22209_(), id -> ArrayListMultimap.create());
                        multimap.put((Object)entityAttribute, (Object)entityAttributeModifier.attributeModifier());
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        Multimap multimap = mergedMultiTotal.computeIfAbsent(entityAttributeModifier.attributeModifier().m_22209_(), id -> ArrayListMultimap.create());
                        multimap.put((Object)entityAttribute, (Object)entityAttributeModifier.attributeModifier());
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$getAttributeModifiersForSlot$7(Multimap merged, Map.Entry entry) {
        merged.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$5(Multimap map3, Map.Entry entityAttributeEntityAttributeModifierHolderEntry) {
        map3.put((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey()), (Object)((EntityAttributeModifierHolder)entityAttributeEntityAttributeModifierHolderEntry.getValue()));
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$4(Multimap map2, Map.Entry entityAttributeEntityAttributeModifierHolderEntry) {
        map2.put((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey()), (Object)((EntityAttributeModifierHolder)entityAttributeEntityAttributeModifierHolderEntry.getValue()));
    }

    private static /* synthetic */ void lambda$mergeAttributes$3(Multimap mergedList, Map.Entry entityAttributeEntityAttributeModifierHolderEntry) {
        if (!mergedList.get((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey())).contains(entityAttributeEntityAttributeModifierHolderEntry.getValue())) {
            mergedList.put((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey()), (Object)((AttributeModifier)entityAttributeEntityAttributeModifierHolderEntry.getValue()));
        }
    }

    private static /* synthetic */ void lambda$mergeAttributes$2(Multimap mergedList, Map.Entry entityAttributeEntityAttributeModifierHolderEntry) {
        if (!mergedList.get((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey())).contains(entityAttributeEntityAttributeModifierHolderEntry.getValue())) {
            mergedList.put((Object)((Attribute)entityAttributeEntityAttributeModifierHolderEntry.getKey()), (Object)((AttributeModifier)entityAttributeEntityAttributeModifierHolderEntry.getValue()));
        }
    }

    static {
        replaceMap = new HashMap<String, Supplier<Attribute>>();
        priorityMap = new HashMap<Attribute, Float>();
        attributeTransformers = new ArrayList<AttributeTransformer>();
        uuidCache = new HashMap<EquipmentSlot, UUID>();
        slotCacheLookUP = new HashMap<EquipmentSlot, Map<AttributeModifier.Operation, UUID>>();
    }

    public record EntityAttributeModifierHolder(AttributeModifier attributeModifier, EquipmentSlot slot, boolean seperateOnItem, AttributeModifier.Operation mergeTo) {
    }

    public static interface AttributeTransformer {
        public Multimap<Attribute, EntityAttributeModifierHolder> transform(Multimap<Attribute, EntityAttributeModifierHolder> var1, ItemStack var2);
    }

    public static interface UUIDGetter {
        public UUID fromSlot(EquipmentSlot var1, AttributeModifier.Operation var2);
    }

    public static class AttributeJson {
        public String attribute;
        public String value;
        public String operation;
        public String slot;
        public String uuid;
        public boolean seperateOnItem;
        public String target_operation;
    }
}

