/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.event.EventResult;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class ArmorPenProperty
extends DoubleProperty {
    public static final String KEY = "armor_pen";
    public static ArmorPenProperty property;
    private static WeakHashMap<LivingEntity, Multimap<Attribute, AttributeModifier>> cache;

    public ArmorPenProperty() {
        super(KEY);
        property = this;
        MiapiEvents.LIVING_HURT.register(event -> {
            Entity patt1138$temp = event.damageSource.m_7639_();
            if (patt1138$temp instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)patt1138$temp;
                ItemStack itemStack = event.getCausingItemStack();
                if (property.hasValue(itemStack)) {
                    double value = property.getValueSafe(itemStack) / 100.0;
                    ArrayListMultimap multimap = ArrayListMultimap.create();
                    multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier("tempArmorPen", -1.0 + value, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    cache.put(event.defender, (Multimap<Attribute, AttributeModifier>)multimap);
                    event.defender.m_21204_().m_22178_((Multimap)multimap);
                }
            }
            return EventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            if (cache.containsKey(event.defender)) {
                event.defender.m_21204_().m_22161_(cache.get(event.defender));
            }
            return EventResult.pass();
        });
    }

    public static double valueRemap(double value) {
        return 100.0 - (200.0 / (1.0 + Math.exp(-value / 120.0)) - 100.0);
    }

    @Override
    public Double getValue(ItemStack stack) {
        Double value = this.getValueRaw(stack);
        if (value != null) {
            return ArmorPenProperty.valueRemap(value);
        }
        return null;
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        Double value = this.getValueRaw(stack);
        return ArmorPenProperty.valueRemap(Objects.requireNonNullElse(value, 0.0));
    }

    static {
        cache = new WeakHashMap();
    }
}

