/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class AllowedSlots
implements ModuleProperty {
    public static final String KEY = "allowedInSlots";

    public static List<String> getAllowedSlots(ItemModule module) {
        JsonElement data = module.getProperties().get(KEY);
        if (data == null) {
            return List.of();
        }
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();
        return (List)gson.fromJson(data, type);
    }

    public static List<ItemModule> allowedIn(SlotProperty.ModuleSlot slot) {
        if (slot == null) {
            return new ArrayList<ItemModule>();
        }
        return RegistryInventory.modules.getFlatMap().values().stream().filter(m -> slot.allowed.stream().anyMatch(s -> AllowedSlots.getAllowedSlots(m).contains(s))).toList();
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();
        gson.fromJson(data, type);
        return true;
    }
}

