/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material.palette;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.palette.SpriteFromJson;
import smartin.miapi.modules.material.palette.SpritePixelReplacer;

public class SpriteOverlayer
extends SpritePixelReplacer {
    public final Color averageColor;
    public final SpriteFromJson delegate;
    protected NativeImageGetter.ImageHolder overlayImage;

    public SpriteOverlayer(Material material, JsonElement json) {
        super(material);
        this.delegate = new SpriteFromJson(json);
        this.averageColor = this.delegate.getAverageColor();
    }

    @Override
    public Color getAverageColor() {
        return this.averageColor;
    }

    @Override
    public int getReplacementColor(int x, int y, int previousAbgr) {
        int abgr = this.overlayImage.getColor(x % this.overlayImage.getWidth(), y % this.overlayImage.getHeight());
        int alpha = FastColor.ABGR32.m_266503_((int)abgr);
        if (alpha != 255) {
            float overlayA = (float)alpha / 255.0f;
            int overlayR = FastColor.ABGR32.m_266313_((int)abgr);
            int overlayG = FastColor.ABGR32.m_266446_((int)abgr);
            int overlayB = FastColor.ABGR32.m_266247_((int)abgr);
            float baseA = (float)FastColor.ABGR32.m_266503_((int)previousAbgr) / 255.0f;
            int baseR = FastColor.ABGR32.m_266313_((int)previousAbgr);
            int baseG = FastColor.ABGR32.m_266446_((int)previousAbgr);
            int baseB = FastColor.ABGR32.m_266247_((int)previousAbgr);
            int newR = Mth.m_269140_((float)overlayA, (int)baseR, (int)overlayR);
            int newG = Mth.m_269140_((float)overlayA, (int)baseG, (int)overlayG);
            int newB = Mth.m_269140_((float)overlayA, (int)baseB, (int)overlayB);
            int newA = (int)(Mth.m_14179_((float)baseA, (float)overlayA, (float)1.0f) * 255.0f);
            return FastColor.ABGR32.m_266248_((int)newA, (int)newB, (int)newG, (int)newR);
        }
        return abgr;
    }

    @Override
    public NativeImage transform(SpriteContents sprite) {
        this.overlayImage = this.delegate.getNativeImage();
        this.delegate.markUse();
        NativeImage result = super.transform(sprite);
        this.overlayImage = null;
        return result;
    }

    @Override
    public boolean doTick() {
        return this.delegate.isAnimated();
    }
}

