/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material.palette;

import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.mixin.client.SpriteContentsAccessor;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.palette.SpritePixelReplacer;

public class PaletteAtlasBackedColorer
extends SpritePixelReplacer {
    protected ResourceLocation spriteId = Material.BASE_PALETTE_ID;
    protected Color averageColor;
    protected boolean isAnimated = false;
    protected NativeImageGetter.ImageHolder image;
    protected SpriteContents contents;

    protected PaletteAtlasBackedColorer(Material material) {
        super(material);
    }

    public PaletteAtlasBackedColorer(Material material, ResourceLocation id) {
        super(material);
        this.setupSprite(id);
    }

    public PaletteAtlasBackedColorer(Material material, JsonElement json) {
        super(material);
        ResourceLocation id = new ResourceLocation(json.getAsJsonObject().get("location").getAsString());
        this.setupSprite(id);
    }

    @Override
    public int getReplacementColor(int pixelX, int pixelY, int previousAbgr) {
        int red = FastColor.ABGR32.m_266313_((int)previousAbgr);
        return this.image.getColor(Mth.m_14045_((int)red, (int)0, (int)255), 0);
    }

    public void setupSprite(ResourceLocation id) {
        this.spriteId = id;
        MiapiClient.materialAtlasManager.addSpriteToLoad(id, c -> {
            this.contents = c;
            this.isAnimated = this.isAnimatedSprite((SpriteContents)c);
        });
    }

    @Nullable
    public ResourceLocation getSpriteId() {
        return this.spriteId;
    }

    @Override
    public boolean doTick() {
        return this.isAnimated;
    }

    @Override
    public NativeImage transform(SpriteContents originalSprite) {
        if (this.contents == null) {
            TextureAtlasSprite sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.getSpriteId());
            MaterialSpriteManager.markTextureAsAnimatedInUse(sprite);
            this.contents = sprite.m_245424_();
        }
        this.image = NativeImageGetter.get(this.contents);
        NativeImage result = super.transform(originalSprite);
        this.image = null;
        return result;
    }

    @Override
    public Color getAverageColor() {
        if (this.averageColor == null) {
            NativeImage img = ((SpriteContentsAccessor)MiapiClient.materialAtlasManager.getMaterialSprite(this.spriteId).m_245424_()).getImage();
            ArrayList<Color> colors = new ArrayList<Color>();
            int height = img.m_85084_();
            int width = img.m_84982_();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = img.m_84985_(x, y);
                    colors.add(new Color(FastColor.ABGR32.m_266313_((int)color), FastColor.ABGR32.m_266446_((int)color), FastColor.ABGR32.m_266247_((int)color), FastColor.ABGR32.m_266503_((int)color)));
                }
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            for (Color color : colors) {
                if (color.a() <= 0) continue;
                red += color.r();
                green += color.g();
                blue += color.b();
                alpha += color.a();
            }
            this.averageColor = new Color(red / colors.size(), green / colors.size(), blue / colors.size(), alpha / colors.size());
        }
        return this.averageColor;
    }
}

