/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.CopyParentMaterialProperty;
import smartin.miapi.modules.material.GeneratedMaterial;
import smartin.miapi.modules.material.JsonMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialProperty
implements ModuleProperty {
    public static final String KEY = "material";
    public static ModuleProperty property;
    public static Map<String, Material> materials;

    public MaterialProperty() {
        property = this;
        StatResolver.registerResolver(KEY, new StatResolver.Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                try {
                    Material material = MaterialProperty.getMaterial(instance);
                    if (material != null) {
                        return material.getDouble(data);
                    }
                }
                catch (Exception exception) {
                    Miapi.LOGGER.warn("Error during Material Resolve", (Throwable)exception);
                }
                return 0.0;
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                try {
                    Material material = MaterialProperty.getMaterial(instance);
                    if (material != null) {
                        return material.getData(data);
                    }
                }
                catch (Exception exception) {
                    Miapi.LOGGER.warn("Error during Material Resolve", (Throwable)exception);
                }
                return "";
            }
        });
        GeneratedMaterial.setup();
        LifecycleEvent.SERVER_BEFORE_START.register(server -> materials.values().stream().filter(GeneratedMaterial.class::isInstance).forEach(generatedMaterial -> ((GeneratedMaterial)generatedMaterial).testForSmithingMaterial(false)));
        ReloadEvents.END.subscribe(isClient -> {
            if (isClient) {
                Minecraft.m_91087_().execute(() -> {
                    RenderSystem.assertOnRenderThread();
                    MiapiClient.materialAtlasManager.m_245256_(null, Minecraft.m_91087_().m_91307_());
                });
            }
        }, 1.0f);
        ReloadEvents.END.subscribe(isClient -> Miapi.LOGGER.info("Loaded " + materials.size() + " Materials"));
    }

    public static void register() {
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "materials", materials, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(data).getAsJsonObject();
            JsonMaterial material = new JsonMaterial(obj, (boolean)isClient);
            if (materials.containsKey(material.getKey())) {
                Miapi.LOGGER.warn("Overwriting Materials isnt 100% safe. The ordering might be wrong, please set the overwrite material in the same path as the origin Material" + path + " is overwriting " + material.getKey());
            }
            materials.put(material.getKey(), material);
        }), -2.0f);
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "material_extensions", isClient -> {}, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(data).getAsJsonObject();
            Material material = materials.get(obj.get("key").getAsString());
            if (material != null) {
                if (material instanceof JsonMaterial) {
                    JsonMaterial jsonMaterial = (JsonMaterial)material;
                    jsonMaterial.mergeJson((JsonElement)obj, (boolean)isClient);
                }
            } else {
                Miapi.LOGGER.error("Miapi could not find Material for Material extension " + path);
            }
        }), -1.5f);
    }

    public static List<String> getTextureKeys() {
        HashSet<String> textureKeys = new HashSet<String>();
        textureKeys.add("base");
        for (Material material : materials.values()) {
            textureKeys.add(material.getKey());
            textureKeys.addAll(material.getTextureKeys());
        }
        return new ArrayList<String>(textureKeys);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case EXTEND: {
                return old;
            }
            case SMART: 
            case OVERWRITE: {
                return toMerge;
            }
        }
        return old;
    }

    @Nullable
    public static Material getMaterialFromIngredient(ItemStack item) {
        double lowestPrio = Double.MAX_VALUE;
        Material foundMaterial = null;
        for (Material material : materials.values()) {
            Double matPrio = material.getPriorityOfIngredientItem(item);
            if (matPrio == null || !(matPrio < lowestPrio)) continue;
            lowestPrio = matPrio;
            foundMaterial = material;
        }
        if (foundMaterial != null) {
            return foundMaterial.getMaterialFromIngredient(item);
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(JsonElement element) {
        if (element != null) {
            return materials.get(element.getAsString());
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(ItemModule.ModuleInstance instance) {
        Material basicMaterial;
        JsonElement element = instance.getProperties().get(property);
        if (element != null && (basicMaterial = materials.get(element.getAsString())) != null) {
            return basicMaterial.getMaterial(instance);
        }
        if (CopyParentMaterialProperty.property.isTrue(instance) && instance.parent != null) {
            return MaterialProperty.getMaterial(instance.parent);
        }
        return null;
    }

    public static void setMaterial(ItemModule.ModuleInstance instance, String material) {
        String propertyString = instance.moduleData.computeIfAbsent("properties", key -> "{material:empty}");
        JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(propertyString, JsonObject.class);
        moduleJson.addProperty(KEY, material);
        instance.moduleData.put("properties", Miapi.gson.toJson((JsonElement)moduleJson));
    }

    static {
        materials = new ConcurrentHashMap<String, Material>(){};
    }

    public static class CurrentThreadExecutor
    implements Executor {
        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }
}

