/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.network.Networking;

public class MaterialCommand {
    public static String SEND_MATERIAL_CLIENT = "miapi_material_debug";
    private static final SuggestionProvider<CommandSourceStack> MATERIAL_SUGGESTIONS = (context, builder) -> {
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        materialOptions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)Commands.m_82127_((String)"miapi").then(Commands.m_82127_((String)"material").then(Commands.m_82129_((String)"material_id", (ArgumentType)StringArgumentType.word()).suggests(MATERIAL_SUGGESTIONS).executes(MaterialCommand::executeMaterialCommand)));
        LiteralArgumentBuilder getHand = (LiteralArgumentBuilder)Commands.m_82127_((String)"miapi").then(Commands.m_82127_((String)"get-hand-material").executes(MaterialCommand::getHandMaterial));
        dispatcher.register(literal);
        dispatcher.register(getHand);
    }

    private static int getHandMaterial(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).m_230897_()) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            Material material = MaterialProperty.getMaterialFromIngredient(player.m_21205_());
            if (material != null) {
                player.m_213846_((Component)Component.m_237113_((String)("Handheld Material " + material.getKey())));
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.m_130070_(material.getKey());
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((CommandSourceStack)context.getSource()).m_230896_(), buf);
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Handheld Item is no Material"));
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Handheld Item is no Material"));
        return 0;
    }

    private static int executeMaterialCommand(CommandContext<CommandSourceStack> context) {
        String materialId = StringArgumentType.getString(context, (String)"material_id");
        List<String> materialOptions = MaterialCommand.getMaterialOptions();
        if (materialOptions.contains(materialId)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Material ID is valid: " + materialId)), false);
            if (((CommandSourceStack)context.getSource()).m_230897_()) {
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.m_130070_(materialId);
                Networking.sendS2C(SEND_MATERIAL_CLIENT, ((CommandSourceStack)context.getSource()).m_230896_(), buf);
            }
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid material ID: " + materialId)));
        return 0;
    }

    private static List<Suggestion> suggestMaterialOptions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        MaterialCommand.getMaterialOptions().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return ((Suggestions)builder.buildFuture().join()).getList();
    }

    static ArgumentType<String> getArgumentType() {
        return new ArgumentType<String>(){

            public String parse(StringReader reader) {
                return reader.getRead();
            }

            public Collection<String> getExamples() {
                return MaterialCommand.getMaterialOptions();
            }
        };
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.materials.keySet().stream().toList();
    }
}

