/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialIcons;
import smartin.miapi.modules.material.palette.FallbackColorer;
import smartin.miapi.modules.material.palette.MaterialRenderController;
import smartin.miapi.modules.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.FakeTranslation;
import smartin.miapi.registries.RegistryInventory;

public class JsonMaterial
implements Material {
    public String key;
    protected JsonElement rawJson;
    @Nullable
    public MaterialIcons.MaterialIcon icon;
    protected MaterialRenderController palette;
    public Map<String, Map<ModuleProperty, JsonElement>> propertyMap = new HashMap<String, Map<ModuleProperty, JsonElement>>();
    public Map<String, Map<ModuleProperty, JsonElement>> displayPropertyMap = new HashMap<String, Map<ModuleProperty, JsonElement>>();
    public Optional<Boolean> generateConvertersOptional = Optional.empty();
    Ingredient matching;

    public JsonMaterial(JsonObject element, boolean isClient) {
        this.rawJson = element;
        this.key = element.get("key").getAsString();
        if (isClient) {
            if (element.has("icon")) {
                JsonPrimitive primitive;
                JsonElement emnt = element.get("icon");
                this.icon = emnt instanceof JsonPrimitive && (primitive = (JsonPrimitive)emnt).isString() ? new MaterialIcons.TextureMaterialIcon(new ResourceLocation(primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.key, emnt);
            }
            this.palette = element.has("color_palette") ? ((MaterialRenderControllers.RenderControllerCreator)MaterialRenderControllers.paletteCreator.dispatcher()).createPalette(element.get("color_palette"), this) : new FallbackColorer(this);
            if (element.has("fake_translation") && element.has("translation")) {
                FakeTranslation.translations.put(element.get("translation").getAsString(), element.get("fake_translation").getAsString());
            }
        }
        this.mergeJson(this.rawJson, isClient);
    }

    public void mergeJson(JsonElement rootElement, boolean isClient) {
        rootElement.getAsJsonObject().asMap().forEach((elementName, propertyElement) -> {
            switch (elementName) {
                case "properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.propertyMap);
                    JsonMaterial.mergeProperties(propertyElement, this.displayPropertyMap);
                    break;
                }
                case "display_properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.displayPropertyMap);
                    break;
                }
                case "hidden_properties": {
                    JsonMaterial.mergeProperties(propertyElement, this.propertyMap);
                    break;
                }
                case "color_palette": {
                    if (!isClient) break;
                    this.palette = ((MaterialRenderControllers.RenderControllerCreator)MaterialRenderControllers.paletteCreator.dispatcher()).createPalette((JsonElement)propertyElement, this);
                    break;
                }
                case "icon": {
                    JsonPrimitive primitive;
                    if (!isClient) break;
                    JsonElement emnt = propertyElement;
                    if (emnt instanceof JsonPrimitive && (primitive = (JsonPrimitive)emnt).isString()) {
                        this.icon = new MaterialIcons.TextureMaterialIcon(new ResourceLocation(primitive.getAsString()));
                        break;
                    }
                    this.icon = MaterialIcons.getMaterialIcon(this.key, emnt);
                    break;
                }
                case "fake_translation": {
                    if (!isClient) break;
                    FakeTranslation.translations.put(this.rawJson.getAsJsonObject().get("translation").getAsString(), propertyElement.getAsString());
                    break;
                }
                case "generate_converters": {
                    this.generateConvertersOptional = Optional.of(propertyElement.getAsBoolean());
                    break;
                }
                default: {
                    this.rawJson.getAsJsonObject().add(elementName, propertyElement);
                }
            }
        });
    }

    private static void mergeProperties(JsonElement propertyElement, Map<String, Map<ModuleProperty, JsonElement>> properties) {
        propertyElement.getAsJsonObject().asMap().forEach((id, element) -> {
            if (element != null) {
                element.getAsJsonObject().entrySet().forEach(stringJsonElementEntry -> {
                    ModuleProperty property = RegistryInventory.moduleProperties.get((String)stringJsonElementEntry.getKey());
                    Map specificPropertyMap = properties.getOrDefault(id, new HashMap());
                    if (property != null) {
                        if (specificPropertyMap.containsKey(property)) {
                            specificPropertyMap.put(property, property.merge((JsonElement)specificPropertyMap.get(property), (JsonElement)stringJsonElementEntry.getValue(), MergeType.SMART));
                        } else {
                            specificPropertyMap.put(property, (JsonElement)stringJsonElementEntry.getValue());
                        }
                    }
                    properties.put((String)id, specificPropertyMap);
                });
            }
        });
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public boolean generateConverters() {
        return this.generateConvertersOptional.orElse(MiapiConfig.INSTANCE.server.generatedMaterials.defaultGenerateConverters);
    }

    @Override
    public List<String> getGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(this.key);
        try {
            String group;
            JsonArray groupsJson;
            if (this.rawJson.getAsJsonObject().has("groups")) {
                groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("groups");
                for (JsonElement groupElement : groupsJson) {
                    group = groupElement.getAsString();
                    groups.add(group);
                }
            }
            if (this.rawJson.getAsJsonObject().has("hidden_groups")) {
                groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("hidden_groups");
                for (JsonElement groupElement : groupsJson) {
                    group = groupElement.getAsString();
                    groups.add(group);
                }
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("Groups were not correctly set up in json Material!" + this.getKey() + " " + String.valueOf(this.rawJson));
        }
        return groups;
    }

    @Override
    public List<String> getGuiGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(this.key);
        try {
            if (this.rawJson.getAsJsonObject().has("groups")) {
                JsonArray groupsJson = this.rawJson.getAsJsonObject().getAsJsonArray("groups");
                for (JsonElement groupElement : groupsJson) {
                    String group = groupElement.getAsString();
                    groups.add(group);
                }
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.warn("Groups were not correctly set up in json Material!" + this.getKey() + " " + String.valueOf(this.rawJson));
        }
        return groups;
    }

    @Override
    public Map<ModuleProperty, JsonElement> materialProperties(String key) {
        return this.propertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public Map<ModuleProperty, JsonElement> getDisplayMaterialProperties(String key) {
        return this.displayPropertyMap.getOrDefault(key, new HashMap());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>(this.propertyMap.keySet());
    }

    @Override
    public List<String> getAllDisplayPropertyKeys() {
        return new ArrayList<String>(this.displayPropertyMap.keySet());
    }

    public JsonElement getRawElement(String key) {
        return this.rawJson.getAsJsonObject().get(key);
    }

    @Override
    public double getDouble(String property) {
        String[] keys = property.split("\\.");
        JsonElement jsonData = this.rawJson;
        for (String k : keys) {
            if ((jsonData = jsonData.getAsJsonObject().get(k)) == null || !jsonData.isJsonObject()) break;
        }
        if (jsonData != null && jsonData.isJsonNull()) {
            Miapi.LOGGER.info(String.valueOf(this.rawJson));
        }
        if (jsonData != null && jsonData.isJsonPrimitive()) {
            return jsonData.getAsDouble();
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        String[] keys = property.split("\\.");
        JsonElement jsonData = this.rawJson;
        for (String key : keys) {
            if ((jsonData = jsonData.getAsJsonObject().get(key)) == null || !jsonData.isJsonObject()) break;
        }
        if (jsonData != null && jsonData.isJsonPrimitive()) {
            return jsonData.getAsString();
        }
        return "";
    }

    @Override
    public List<String> getTextureKeys() {
        ArrayList<String> textureKeys = new ArrayList<String>();
        if (this.rawJson.getAsJsonObject().has("textures")) {
            try {
                JsonArray textures = this.rawJson.getAsJsonObject().getAsJsonArray("textures");
                for (JsonElement texture : textures) {
                    textureKeys.add(texture.getAsString());
                }
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.warn("textures in material " + this.getKey() + " is not setup correctly");
            }
        }
        textureKeys.add("default");
        return new ArrayList<String>(textureKeys);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor() {
        if (this.rawJson.getAsJsonObject().get("color") != null) {
            try {
                long longValue = Long.parseLong(this.rawJson.getAsJsonObject().get("color").getAsString(), 16);
                return (int)(longValue & 0xFFFFFFFFL);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.warn("textures in material " + this.getKey() + " is not setup correctly");
            }
        }
        return this.getRenderController().getAverageColor().argb();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController() {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public double getValueOfItem(ItemStack item) {
        JsonArray items = this.rawJson.getAsJsonObject().getAsJsonArray("items");
        for (JsonElement element : items) {
            Ingredient ingredient;
            JsonObject itemObj = element.getAsJsonObject();
            if (itemObj.has("item")) {
                String itemId = itemObj.get("item").getAsString();
                if (!BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).toString().equals(itemId)) continue;
                try {
                    Item item1 = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemId));
                    this.matching = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item1});
                    return itemObj.get("value").getAsDouble();
                }
                catch (Exception surpressed) {
                    return 1.0;
                }
            }
            if (itemObj.has("tag")) {
                String tagId = itemObj.get("tag").getAsString();
                TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(tagId));
                this.matching = Ingredient.m_204132_((TagKey)tag);
                if (tag == null || !item.m_204117_(tag)) continue;
                try {
                    return itemObj.get("value").getAsDouble();
                }
                catch (Exception suppressed) {
                    return 1.0;
                }
            }
            if (!itemObj.has("ingredient")) continue;
            this.matching = ingredient = Ingredient.m_43917_((JsonElement)itemObj.get("ingredient"));
            if (!ingredient.test(item)) continue;
            try {
                return itemObj.get("value").getAsDouble();
            }
            catch (Exception suppressed) {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public Ingredient getIngredient() {
        if (this.matching == null) {
            this.getValueOfItem(ItemStack.f_41583_);
        }
        return this.matching;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (this.getRawElement("items") != null && this.getRawElement("items").isJsonArray()) {
            JsonObject itemObj;
            JsonArray items = this.getRawElement("items").getAsJsonArray();
            for (JsonElement element : items) {
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("item")) continue;
                String itemId = itemObj.get("item").getAsString();
                if (!BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).toString().equals(itemId)) continue;
                return 0.0;
            }
            for (JsonElement element : items) {
                Ingredient ingredient;
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("ingredient") || !(ingredient = Ingredient.m_43917_((JsonElement)itemObj.get("ingredient"))).test(itemStack)) continue;
                return 5.0;
            }
            for (JsonElement element : items) {
                itemObj = element.getAsJsonObject();
                if (!itemObj.has("tag")) continue;
                String tagId = itemObj.get("tag").getAsString();
                TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(tagId));
                if (tag == null || !itemStack.m_204117_(tag)) continue;
                return 10.0;
            }
        }
        return null;
    }

    @Override
    public JsonObject getDebugJson() {
        return this.rawJson.getAsJsonObject();
    }
}

