/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.redpxnda.nucleus.util.Color;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.MaterialSmithingRecipe;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.mixin.MiningToolItemAccessor;
import smartin.miapi.mixin.SmithingTransformRecipeAccessor;
import smartin.miapi.modules.material.JsonMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialIcons;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.material.NBTMaterial;
import smartin.miapi.modules.material.NamingUtil;
import smartin.miapi.modules.material.palette.FallbackColorer;
import smartin.miapi.modules.material.palette.GrayscalePaletteColorer;
import smartin.miapi.modules.material.palette.MaterialRenderController;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.FakeTranslation;
import smartin.miapi.registries.RegistryInventory;

public class GeneratedMaterial
implements Material {
    public final Tier toolMaterial;
    public final ItemStack mainIngredient;
    public final String key;
    public final List<String> groups = new ArrayList<String>();
    public final Map<String, Double> materialStats = new HashMap<String, Double>();
    public final Map<String, String> materialStatsString = new HashMap<String, String>();
    public SwordItem swordItem;
    protected GrayscalePaletteColorer palette;
    @Nullable
    public MaterialIcons.MaterialIcon icon;
    public static final List<ItemStack> generatedItems = new ArrayList<ItemStack>();
    public static final List<ItemStack> generatedItemsTool = new ArrayList<ItemStack>();
    public static final List<Tuple<ItemStack, ItemStack>> generatedMaterials = new ArrayList<Tuple<ItemStack, ItemStack>>();
    public static final List<Item> woodItems = new ArrayList<Item>();
    public static final List<Item> stoneItems = new ArrayList<Item>();
    public JsonElement iconJson;
    public boolean isComplex = true;
    public String langKey;
    public String fakeTranslation;

    public static void setup() {
        ReloadEvents.MAIN.subscribe(isClient -> {
            if (isClient) {
                GeneratedMaterial.onReloadClient();
            } else {
                GeneratedMaterial.onReloadServer();
            }
            JsonObject material = new JsonObject();
            material.addProperty("key", "nbt_base_material");
            MaterialProperty.materials.put("nbt_runtime_material", new NBTMaterial(new JsonMaterial(material, isClient), material, isClient));
        }, -1.0f);
        ReloadEvents.DATA_SYNCER_REGIGISTRY.register("generated_materials", new ReloadEvents.DataSyncer(){

            @Override
            public FriendlyByteBuf createDataServer() {
                FriendlyByteBuf packetByteBuf = Networking.createBuffer();
                packetByteBuf.writeInt(generatedMaterials.size());
                for (Tuple<ItemStack, ItemStack> generatedMaterial : generatedMaterials) {
                    ItemStack material = (ItemStack)generatedMaterial.m_14418_();
                    ItemStack sword = (ItemStack)generatedMaterial.m_14419_();
                    packetByteBuf.m_130055_(material);
                    packetByteBuf.m_130055_(sword);
                }
                packetByteBuf.writeInt(woodItems.size());
                for (Item item : woodItems) {
                    packetByteBuf.m_130055_(item.m_7968_());
                }
                packetByteBuf.writeInt(stoneItems.size());
                for (Item item : stoneItems) {
                    packetByteBuf.m_130055_(item.m_7968_());
                }
                return packetByteBuf;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interpretDataClient(FriendlyByteBuf buf) {
                Item item;
                int i;
                ArrayList<ItemStack> generatedMaterials = new ArrayList<ItemStack>();
                ArrayList<ItemStack> generatedMaterialsTools = new ArrayList<ItemStack>();
                ArrayList<Item> stoneMaterials = new ArrayList<Item>();
                ArrayList<Item> woodMaterials = new ArrayList<Item>();
                int genMaterials = buf.readInt();
                for (i = 0; i < genMaterials; ++i) {
                    ItemStack itemStack = buf.m_130267_();
                    ItemStack itemStack2 = buf.m_130267_();
                    generatedMaterials.add(itemStack);
                    generatedMaterialsTools.add(itemStack2);
                }
                genMaterials = buf.readInt();
                for (i = 0; i < genMaterials; ++i) {
                    item = buf.m_130267_().m_41720_();
                    woodMaterials.add(item);
                }
                genMaterials = buf.readInt();
                for (i = 0; i < genMaterials; ++i) {
                    item = buf.m_130267_().m_41720_();
                    stoneMaterials.add(item);
                }
                List<ItemStack> list = generatedItems;
                synchronized (list) {
                    generatedItems.clear();
                    generatedItems.addAll(generatedMaterials);
                    generatedItemsTool.clear();
                    generatedItemsTool.addAll(generatedMaterialsTools);
                }
                list = stoneItems;
                synchronized (list) {
                    stoneItems.clear();
                    stoneItems.addAll(stoneMaterials);
                }
                list = woodItems;
                synchronized (list) {
                    woodItems.clear();
                    woodItems.addAll(woodMaterials);
                }
            }
        });
    }

    public static void onReloadClient() {
        List<TieredItem> toolItems = BuiltInRegistries.f_257033_.m_123024_().filter(TieredItem.class::isInstance).map(TieredItem.class::cast).toList();
        for (int i = 0; i < generatedItems.size(); ++i) {
            ItemStack itemStack = generatedItems.get(i);
            try {
                TieredItem toolItem;
                GeneratedMaterial generatedMaterial;
                ItemStack toolStack = generatedItemsTool.get(i);
                Item item = toolStack.m_41720_();
                if (!(item instanceof TieredItem) || !(generatedMaterial = new GeneratedMaterial((toolItem = (TieredItem)item).m_43314_(), itemStack, true)).assignStats(toolItems, true)) continue;
                MaterialProperty.materials.put(generatedMaterial.getKey(), generatedMaterial);
                continue;
            }
            catch (Exception e) {
                if (itemStack == null) continue;
                Miapi.LOGGER.info("Failure to generate Material on Client for :" + itemStack.m_41778_(), (Throwable)e);
            }
        }
        woodItems.forEach(woodItem -> {
            try {
                GeneratedMaterial generatedMaterial = new GeneratedMaterial((Tier)Tiers.WOOD, woodItem.m_7968_(), true);
                MaterialProperty.materials.put(generatedMaterial.getKey(), generatedMaterial);
                generatedMaterial.setupWood();
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Failure to setup Wood Material for " + woodItem.m_5524_(), (Throwable)e);
            }
        });
        stoneItems.forEach(stoneItem -> {
            try {
                GeneratedMaterial generatedMaterial = new GeneratedMaterial((Tier)Tiers.STONE, stoneItem.m_7968_(), true);
                MaterialProperty.materials.put(generatedMaterial.getKey(), generatedMaterial);
                generatedMaterial.setupStone();
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Failure to setup Stone Material for " + stoneItem.m_5524_(), (Throwable)e);
            }
        });
    }

    public static void onReloadServer() {
        try {
            if (GeneratedMaterial.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI STARTED MATERIAL GENERATION");
            }
            woodItems.clear();
            stoneItems.clear();
            generatedItems.clear();
            if (!MiapiConfig.INSTANCE.server.generatedMaterials.generateMaterials) {
                return;
            }
            List<TieredItem> toolItems = BuiltInRegistries.f_257033_.m_123024_().filter(TieredItem.class::isInstance).map(TieredItem.class::cast).filter(toolMaterial -> toolMaterial.m_43314_().m_6282_() != null && toolMaterial.m_43314_().m_6282_().m_43908_() != null).toList();
            ArrayList toRegister = new ArrayList();
            if (MiapiConfig.INSTANCE.server.generatedMaterials.generateOtherMaterials) {
                toolItems.stream().map(TieredItem::m_43314_).collect(Collectors.toSet()).stream().filter(toolMaterial -> toolMaterial.m_6282_() != null && toolMaterial.m_6282_().m_43908_() != null).filter(toolMaterial -> toolMaterial.m_6282_().m_43908_().length > 0).filter(toolMaterial -> !toolMaterial.m_6282_().m_43908_()[0].m_204117_(RegistryInventory.MIAPI_FORBIDDEN_TAG)).filter(toolMaterial -> Arrays.stream(toolMaterial.m_6282_().m_43908_()).allMatch(itemStack -> MaterialProperty.getMaterialFromIngredient(itemStack) == null && !itemStack.m_41720_().equals(Items.f_42127_))).limit(MiapiConfig.INSTANCE.server.generatedMaterials.maximumGeneratedMaterials).collect(Collectors.toSet()).forEach(toolMaterial -> {
                    try {
                        GeneratedMaterial generatedMaterial;
                        if (GeneratedMaterial.isValidItem(toolMaterial.m_6282_().m_43908_()[0].m_41720_()) && (generatedMaterial = new GeneratedMaterial((Tier)toolMaterial, false)).assignStats(toolItems, false)) {
                            toRegister.add(generatedMaterial);
                            if (GeneratedMaterial.verboseLogging()) {
                                Miapi.LOGGER.info("FOUND MATERIAL " + generatedMaterial.getKey());
                            }
                            generatedMaterials.add((Tuple<ItemStack, ItemStack>)new Tuple((Object)generatedMaterial.mainIngredient, (Object)generatedMaterial.swordItem.m_7968_()));
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate Material for " + String.valueOf(toolMaterial.m_6282_().m_43908_()[0]), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.INSTANCE.server.generatedMaterials.generateWoodMaterials) {
                BuiltInRegistries.f_257033_.m_123024_().filter(item -> item.m_7968_().m_204117_(ItemTags.f_13168_) && GeneratedMaterial.isValidItem(item)).limit(MiapiConfig.INSTANCE.server.generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        GeneratedMaterial generatedMaterial = new GeneratedMaterial((Tier)Tiers.WOOD, item.m_7968_(), false);
                        Material old = MaterialProperty.getMaterialFromIngredient(item.m_7968_());
                        if (old == null || old == MaterialProperty.materials.get("wood")) {
                            woodItems.add((Item)item);
                            toRegister.add(generatedMaterial);
                            generatedMaterial.setupWood();
                            MaterialProperty.materials.put(generatedMaterial.getKey(), generatedMaterial);
                            if (GeneratedMaterial.verboseLogging()) {
                                Miapi.LOGGER.info("FOUND WOOD MATERIAL " + generatedMaterial.getKey());
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate wood Material for " + item.m_5524_(), (Throwable)e);
                    }
                });
            }
            if (MiapiConfig.INSTANCE.server.generatedMaterials.generateStoneMaterials) {
                BuiltInRegistries.f_257033_.m_123024_().filter(item -> item.m_7968_().m_204117_(ItemTags.f_13165_) && GeneratedMaterial.isValidItem(item)).limit(MiapiConfig.INSTANCE.server.generatedMaterials.maximumGeneratedMaterials).forEach(item -> {
                    try {
                        GeneratedMaterial generatedMaterial = new GeneratedMaterial((Tier)Tiers.STONE, item.m_7968_(), false);
                        Material old = MaterialProperty.getMaterialFromIngredient(item.m_7968_());
                        if (old == null || old == MaterialProperty.materials.get("stone")) {
                            toRegister.add(generatedMaterial);
                            generatedMaterial.setupStone();
                            stoneItems.add((Item)item);
                            MaterialProperty.materials.put(generatedMaterial.getKey(), generatedMaterial);
                            if (GeneratedMaterial.verboseLogging()) {
                                Miapi.LOGGER.info("FOUND STONE MATERIAL " + generatedMaterial.getKey());
                            }
                        }
                    }
                    catch (Exception e) {
                        Miapi.LOGGER.error("could not generate stone Material for " + item.m_5524_(), (Throwable)e);
                    }
                });
            }
            for (Material material : toRegister) {
                MaterialProperty.materials.put(material.getKey(), material);
            }
            toolItems.stream().map(TieredItem::m_43314_).collect(Collectors.toSet()).stream().filter(toolMaterial -> toolMaterial.m_6282_() != null && toolMaterial.m_6282_().m_43908_() != null).filter(toolMaterial -> toolMaterial.m_6282_().m_43908_().length > 0).filter(toolMaterial -> !toolMaterial.m_6282_().m_43908_()[0].m_204117_(RegistryInventory.MIAPI_FORBIDDEN_TAG)).filter(toolMaterial -> toolMaterial.m_6282_().m_43908_()[0].m_41720_().equals(Items.f_42127_)).forEach(toolMaterial -> {
                Material material = MaterialProperty.getMaterialFromIngredient(toolMaterial.m_6282_().m_43908_()[0]);
                if (material != null) {
                    List<Item> toolMaterials = toolItems.stream().filter(toolMat -> toolMaterial.equals(toolMat.m_43314_())).filter(tool -> {
                        ItemStack toolItem = tool.m_7968_();
                        return ModularItemStackConverter.getModularVersion(toolItem) == toolItem;
                    }).collect(Collectors.toList());
                    if (material.generateConverters()) {
                        try {
                            ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(material, toolMaterials, false);
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.error("error during Material Creation event " + String.valueOf(material) + " ", (Throwable)e);
                        }
                    }
                }
            });
            if (GeneratedMaterial.verboseLogging()) {
                Miapi.LOGGER.info("MIAPI FINISHED MATERIAL GENERATION");
            }
        }
        catch (Exception e) {
            Miapi.LOGGER.error("MAJOR ISSUE DURING MATERIAL CREATION", (Throwable)e);
        }
    }

    public static boolean verboseLogging() {
        return MiapiConfig.INSTANCE.server.other.verboseLogging;
    }

    public static boolean isValidItem(Item item) {
        ResourceLocation identifier = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        if (item.m_7968_().m_204117_(RegistryInventory.MIAPI_FORBIDDEN_TAG)) {
            return false;
        }
        Pattern pattern = Pattern.compile(MiapiConfig.INSTANCE.server.generatedMaterials.blockRegex);
        return !pattern.matcher(identifier.toString()).find();
    }

    public GeneratedMaterial(Tier toolMaterial, boolean isClient) {
        this(toolMaterial, toolMaterial.m_6282_().m_43908_()[0], isClient);
    }

    public GeneratedMaterial(Tier toolMaterial, ItemStack itemStack, boolean isClient) {
        this.toolMaterial = toolMaterial;
        this.mainIngredient = itemStack;
        this.key = "generated_" + this.mainIngredient.m_41778_();
        this.groups.add(this.key);
        if (this.mainIngredient.m_41778_().contains("ingot")) {
            this.groups.add("metal");
        }
        if (this.mainIngredient.m_41778_().contains("stone")) {
            this.groups.add("stone");
        }
        if (this.mainIngredient.m_41778_().contains("bone")) {
            this.groups.add("bone");
        }
        if (this.mainIngredient.m_204117_(ItemTags.f_13168_)) {
            this.groups.add("wood");
        }
        if (this.groups.size() == 1) {
            this.groups.add("crystal");
        }
        this.materialStats.put("durability", Double.valueOf(toolMaterial.m_6609_()));
        this.materialStats.put("mining_level", Double.valueOf(toolMaterial.m_6604_()));
        this.materialStats.put("mining_speed", Double.valueOf(toolMaterial.m_6624_()));
        this.materialStats.put("enchantability", Double.valueOf(toolMaterial.m_6601_()));
        if (isClient) {
            this.clientSetup();
        }
    }

    public void setupWood() {
        this.groups.clear();
        this.groups.add(this.key);
        this.groups.add("wood");
        this.isComplex = false;
        this.copyStatsFrom(MaterialProperty.materials.get("wood"));
    }

    public void setupStone() {
        this.groups.clear();
        this.groups.add(this.key);
        this.groups.add("stone");
        this.isComplex = false;
        this.copyStatsFrom(MaterialProperty.materials.get("stone"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup() {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)this.mainIngredient.m_41720_());
        StringBuilder iconBuilder = new StringBuilder();
        iconBuilder.append("{");
        iconBuilder.append("\"type\": \"").append("item").append("\",");
        iconBuilder.append("\"item\": \"").append(itemId).append("\"");
        iconBuilder.append("}");
        this.iconJson = (JsonElement)Miapi.gson.fromJson(iconBuilder.toString(), JsonObject.class);
        this.icon = MaterialIcons.getMaterialIcon(this.key, this.iconJson);
        this.palette = GrayscalePaletteColorer.createForGeneratedMaterial(this, this.mainIngredient);
    }

    public boolean assignStats(List<TieredItem> toolItems, boolean isClient) {
        Item item;
        List<Item> toolMaterials = toolItems.stream().filter(material -> this.toolMaterial.equals(material.m_43314_())).collect(Collectors.toList());
        Optional<Item> swordItemOptional = toolMaterials.stream().filter(SwordItem.class::isInstance).findFirst();
        Optional<Item> axeItemOptional = toolMaterials.stream().filter(AxeItem.class::isInstance).findFirst();
        if (axeItemOptional.isEmpty()) {
            axeItemOptional = toolMaterials.stream().filter(DiggerItem.class::isInstance).filter(miningTool -> ((MiningToolItemAccessor)miningTool).getEffectiveBlocks().equals((Object)BlockTags.f_144280_)).findFirst();
        }
        if (swordItemOptional.isPresent() && axeItemOptional.isPresent() && (item = swordItemOptional.get()) instanceof SwordItem) {
            SwordItem foundSwordItem = (SwordItem)item;
            item = axeItemOptional.get();
            if (item instanceof DiggerItem) {
                DiggerItem axeItem = (DiggerItem)item;
                this.swordItem = foundSwordItem;
                this.materialStats.put("hardness", Double.valueOf(this.swordItem.m_43299_()));
                double calculatedDamage = Math.floor(Math.pow(((double)this.swordItem.m_43299_() - 3.4) * 2.3, 0.3333333333333333)) + 7.0;
                if (this.groups.contains("stone")) {
                    this.materialStats.put("density", Double.valueOf(this.swordItem.m_43299_()));
                } else if (this.groups.contains("crystal")) {
                    this.materialStats.put("density", Double.valueOf(axeItem.m_41008_()));
                } else {
                    this.materialStats.put("density", (double)this.swordItem.m_43299_() / 3.0);
                }
                if (Math.abs(calculatedDamage - (double)this.swordItem.m_43299_()) > 0.1) {
                    this.materialStats.put("axe_damage", calculatedDamage - (double)this.swordItem.m_43299_());
                }
                if (this.groups.contains("crystal") || this.groups.contains("gemstone")) {
                    this.materialStats.put("flexibility", 0.0);
                } else {
                    this.materialStats.put("flexibility", Double.valueOf(this.toolMaterial.m_6624_() / 4.0f));
                }
                if (Platform.getEnvironment() == Env.CLIENT) {
                    this.generateTranslation(toolMaterials);
                }
                ((MiapiEvents.GeneratedMaterialEvent)MiapiEvents.GENERATED_MATERIAL.invoker()).generated(this, this.mainIngredient, toolMaterials, isClient);
                ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, toolMaterials, isClient);
                return true;
            }
        }
        return false;
    }

    public void testForSmithingMaterial(boolean isClient) {
        RecipeManager manager = GeneratedMaterial.findManager(isClient);
        RegistryAccess registryManager = GeneratedMaterial.findRegistryManager(isClient);
        manager.m_44013_(RecipeType.f_44113_).stream().filter(SmithingTransformRecipe.class::isInstance).map(SmithingTransformRecipe.class::cast).filter(recipe -> GeneratedMaterial.isValidRecipe(recipe, this.swordItem, registryManager)).findAny().ifPresent(smithingTransformRecipe -> {
            ItemStack templateItem = Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getTemplate().m_43908_()).filter(itemStack -> !itemStack.m_41619_()).findAny().orElse(ItemStack.f_41583_);
            if (templateItem.m_41619_()) {
                return;
            }
            Arrays.stream(((SmithingTransformRecipeAccessor)smithingTransformRecipe).getBase().m_43908_()).filter(itemStack -> {
                Item patt24326$temp = itemStack.m_41720_();
                if (patt24326$temp instanceof TieredItem) {
                    TieredItem toolItem = (TieredItem)patt24326$temp;
                    Material material = MaterialProperty.getMaterialFromIngredient(toolItem.m_43314_().m_6282_().m_43908_()[0]);
                    return material != null;
                }
                return false;
            }).map(itemStack -> MaterialProperty.getMaterialFromIngredient(((TieredItem)itemStack.m_41720_()).m_43314_().m_6282_().m_43908_()[0])).findAny().ifPresent(sourceMaterial -> this.addSmithingRecipe((Material)sourceMaterial, templateItem, (SmithingTransformRecipe)smithingTransformRecipe, isClient));
        });
    }

    public void addSmithingRecipe(Material sourceMaterial, ItemStack templateItem, SmithingTransformRecipe smithingTransformRecipe, boolean isClient) {
        RecipeManager manager = GeneratedMaterial.findManager(isClient);
        Collection recipes = manager.m_44051_();
        Object id = "generated_material_recipe." + this.key + "." + String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)templateItem.m_41720_())) + "." + sourceMaterial.getKey();
        ResourceLocation recipeId = new ResourceLocation("miapi", (String)(id = ((String)id).replace(":", ".")));
        if (manager.m_44043_(recipeId).isEmpty()) {
            recipes.add(new MaterialSmithingRecipe(recipeId, Ingredient.m_43927_((ItemStack[])new ItemStack[]{templateItem}), sourceMaterial.getKey(), ((SmithingTransformRecipeAccessor)smithingTransformRecipe).getAddition(), this.key));
            if (GeneratedMaterial.verboseLogging()) {
                Miapi.LOGGER.warn("added Smithing Recipe for " + sourceMaterial.getKey() + " to " + this.key + " via " + String.valueOf(templateItem.m_41720_()));
            }
            this.groups.clear();
            this.groups.add(this.key);
            this.groups.add("smithing");
            manager.m_44024_((Iterable)recipes);
        }
    }

    @Override
    public boolean generateConverters() {
        return true;
    }

    static boolean isValidRecipe(SmithingTransformRecipe recipe, SwordItem swordItem, RegistryAccess manager) {
        if (recipe.m_8043_(manager).m_41720_().equals(swordItem)) {
            return true;
        }
        return ((SmithingTransformRecipeAccessor)recipe).getResult().m_41720_().equals(swordItem);
    }

    static RecipeManager findManager(boolean isClient) {
        if (isClient) {
            return Minecraft.m_91087_().f_91073_.m_7465_();
        }
        return Miapi.server.m_129894_();
    }

    static RegistryAccess findRegistryManager(boolean isClient) {
        if (isClient) {
            return Minecraft.m_91087_().f_91073_.m_9598_();
        }
        return Miapi.server.m_206579_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void generateTranslation(List<Item> items) {
        this.langKey = "miapi.material.generated." + this.mainIngredient.m_41720_().m_5524_();
        this.fakeTranslation = NamingUtil.generateTranslation(items, this.mainIngredient);
        if (!this.fakeTranslation.endsWith(" ")) {
            this.fakeTranslation = this.fakeTranslation + " ";
        }
        FakeTranslation.translations.put(this.langKey, this.fakeTranslation);
        this.materialStatsString.put("translation", this.langKey);
    }

    public void copyStatsFrom(Material other) {
        this.materialStats.put("hardness", other.getDouble("hardness"));
        this.materialStats.put("density", other.getDouble("density"));
        this.materialStats.put("flexibility", other.getDouble("flexibility"));
        this.materialStats.put("durability", other.getDouble("durability"));
        this.materialStats.put("mining_level", other.getDouble("mining_level"));
        this.materialStats.put("mining_speed", other.getDouble("mining_speed"));
        if (Platform.getEnvironment() == Env.CLIENT) {
            this.addFakeTranslationForCopy();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFakeTranslationForCopy() {
        this.fakeTranslation = Component.m_237115_((String)this.mainIngredient.m_41778_()).getString();
        this.langKey = "miapi.material.generated." + this.mainIngredient.m_41720_().m_5524_();
        if (!this.fakeTranslation.endsWith(" ")) {
            this.fakeTranslation = this.fakeTranslation + " ";
        }
        FakeTranslation.translations.put(this.langKey, this.fakeTranslation);
        this.materialStatsString.put("translation", this.langKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public Map<ModuleProperty, JsonElement> materialProperties(String key) {
        return new HashMap<ModuleProperty, JsonElement>();
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>();
    }

    @Override
    public double getDouble(String property) {
        if (this.materialStats.containsKey(property)) {
            return this.materialStats.get(property);
        }
        return 0.0;
    }

    @Override
    public String getData(String property) {
        return this.materialStatsString.get(property);
    }

    @Override
    public List<String> getTextureKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.groups);
        keys.add("default");
        return keys;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController() {
        if (this.palette == null) {
            return new FallbackColorer(this);
        }
        return this.palette;
    }

    @Override
    public double getValueOfItem(ItemStack item) {
        if (this.mainIngredient.m_41720_().equals(item.m_41720_())) {
            return 1.0;
        }
        if (this.isComplex && this.toolMaterial.m_6282_().test(item)) {
            return 1.0;
        }
        return this.isComplex && item.m_41720_().equals(this.mainIngredient.m_41720_()) ? 1.0 : 0.0;
    }

    @Override
    public Ingredient getIngredient() {
        if (this.toolMaterial != null) {
            return this.toolMaterial.m_6282_();
        }
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.mainIngredient.m_41720_()});
    }

    @Override
    @Nullable
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (this.mainIngredient.m_41720_().equals(itemStack.m_41720_())) {
            return 1.0;
        }
        if (this.isComplex && this.toolMaterial.m_6282_().test(itemStack)) {
            return 2.0;
        }
        return null;
    }

    @Override
    public JsonObject getDebugJson() {
        JsonObject object = new JsonObject();
        object.add("key", (JsonElement)new JsonPrimitive(this.getKey()));
        JsonArray jsonElements = new JsonArray();
        this.getTextureKeys().forEach(arg_0 -> ((JsonArray)jsonElements).add(arg_0));
        object.add("groups", (JsonElement)jsonElements);
        this.materialStats.forEach((id, value) -> object.add(id, (JsonElement)new JsonPrimitive((Number)value)));
        if (this.langKey != null) {
            object.add("translation", (JsonElement)new JsonPrimitive(this.langKey));
        }
        if (this.fakeTranslation != null) {
            object.add("fake_translation", (JsonElement)new JsonPrimitive(this.fakeTranslation));
        }
        if (this.iconJson != null) {
            object.add("icon", this.iconJson);
        }
        if (this.palette != null) {
            StringBuilder paletteBuilder = new StringBuilder();
            paletteBuilder.append("{");
            paletteBuilder.append("\"type\": \"").append("grayscale_map").append("\",");
            paletteBuilder.append("\"colors\": ");
            JsonObject innerPalette = new JsonObject();
            for (int i = 0; i < this.palette.getColors().length; ++i) {
                int abgr = this.palette.getColors()[i];
                innerPalette.addProperty(String.valueOf(i), new Color(FastColor.ABGR32.m_266313_((int)abgr), FastColor.ABGR32.m_266446_((int)abgr), FastColor.ABGR32.m_266247_((int)abgr), FastColor.ABGR32.m_266503_((int)abgr)).hex());
            }
            paletteBuilder.append(Miapi.gson.toJson((JsonElement)innerPalette));
            paletteBuilder.append("}");
            object.add("palette", (JsonElement)Miapi.gson.fromJson(paletteBuilder.toString(), JsonObject.class));
        }
        JsonArray ingredients = new JsonArray();
        JsonObject mainIngredientJson = new JsonObject();
        mainIngredientJson.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.f_257033_.m_7981_((Object)this.mainIngredient.m_41720_()).toString()));
        mainIngredientJson.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        JsonObject otherIngredient = new JsonObject();
        otherIngredient.add("ingredient", this.toolMaterial.m_6282_().m_43942_());
        otherIngredient.add("value", (JsonElement)new JsonPrimitive((Number)1.0));
        ingredients.add((JsonElement)mainIngredientJson);
        ingredients.add((JsonElement)otherIngredient);
        object.add("items", (JsonElement)ingredients);
        return object;
    }
}

