/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.config.FunctionDictionaryIfc;
import com.ezylang.evalex.config.OperatorDictionaryIfc;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.operators.AbstractOperator;
import com.ezylang.evalex.operators.InfixOperator;
import com.ezylang.evalex.operators.OperatorIfc;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;

public class EvalExResolverStuff {
    public static ExpressionConfiguration configuration;

    static {
        FunctionDictionaryIfc dictionaryIfc = ExpressionConfiguration.defaultConfiguration().getFunctionDictionary();
        OperatorDictionaryIfc operatorIfc = ExpressionConfiguration.defaultConfiguration().getOperatorDictionary();
        operatorIfc.addOperator("/", (OperatorIfc)new DivisionByZeroAllowed());
        operatorIfc.addOperator("^", (OperatorIfc)new PowerOperatorWorks());
        dictionaryIfc.addFunction("ceil", dictionaryIfc.getFunction("ceiling"));
        configuration = ExpressionConfiguration.builder().allowOverwriteConstants(true).arraysAllowed(true).dataAccessorSupplier(ExpressionConfiguration.defaultConfiguration().getDataAccessorSupplier()).decimalPlacesRounding(-1).defaultConstants(ExpressionConfiguration.StandardConstants).implicitMultiplicationAllowed(true).mathContext(ExpressionConfiguration.DEFAULT_MATH_CONTEXT).powerOfPrecedence(50).stripTrailingZeros(true).structuresAllowed(true).singleQuoteStringLiteralsAllowed(false).functionDictionary(dictionaryIfc).operatorDictionary(operatorIfc).build();
    }

    @InfixOperator(precedence=30)
    public static class DivisionByZeroAllowed
    extends AbstractOperator {
        public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
            EvaluationValue leftOperand = operands[0];
            EvaluationValue rightOperand = operands[1];
            if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
                if (rightOperand.getNumberValue().doubleValue() == 0.0 || leftOperand.getNumberValue().doubleValue() == 0.0) {
                    return EvaluationValue.numberValue((BigDecimal)BigDecimal.ZERO);
                }
                try {
                    BigDecimal decimal = leftOperand.getNumberValue().divide(rightOperand.getNumberValue(), expression.getConfiguration().getMathContext());
                    return expression.convertValue((Object)decimal);
                }
                catch (Exception e) {
                    return EvaluationValue.numberValue((BigDecimal)BigDecimal.valueOf(0.0));
                }
            }
            return EvaluationValue.numberValue((BigDecimal)BigDecimal.valueOf(0.0));
        }
    }

    @InfixOperator(precedence=40, leftAssociative=false)
    public static class PowerOperatorWorks
    extends AbstractOperator {
        public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
            EvaluationValue leftOperand = operands[0];
            EvaluationValue rightOperand = operands[1];
            if (leftOperand.isNumberValue() && rightOperand.isNumberValue()) {
                double v1 = leftOperand.getNumberValue().doubleValue();
                double v2 = rightOperand.getNumberValue().doubleValue();
                double result = v1 < 0.0 ? -Math.pow(-v1, v2) : Math.pow(v1, v2);
                return EvaluationValue.numberValue((BigDecimal)BigDecimal.valueOf(result));
            }
            throw EvaluationException.ofUnsupportedDataTypeInOperation((Token)operatorToken);
        }

        public int getPrecedence(ExpressionConfiguration configuration) {
            return configuration.getPowerOfPrecedence();
        }
    }
}

