/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.TriConsumer;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.SkinTab;
import smartin.miapi.modules.edit_options.skins.gui.SkinGui;

public class SkinOptions
implements EditOption {
    public static Map<ItemModule, Map<String, Skin>> skins = new HashMap<ItemModule, Map<String, Skin>>();
    public static Map<String, SkinTab> tabMap = new HashMap<String, SkinTab>();
    public static SkinTab defaultTab = new SkinTab();

    public SkinOptions() {
        defaultTab = SkinTab.fromJson(null);
        PropertyResolver.register(new ResourceLocation("miapi", "skin"), (moduleInstance, oldMap) -> {
            if (moduleInstance != null) {
                String skinKey = moduleInstance.moduleData.get("skin");
                Map<String, Skin> moduleSkins = skins.get(moduleInstance.module);
                if (skinKey != null && moduleSkins != null && moduleSkins.containsKey(skinKey)) {
                    moduleSkins.get((Object)skinKey).propertyHolder.applyHolder(oldMap);
                }
            }
            return oldMap;
        }, List.of(new ResourceLocation("miapi", "synergy")));
        ReloadEvents.END.subscribe(isClient -> {
            int size = 0;
            for (Map<String, Skin> skinMap : skins.values()) {
                size += skinMap.size();
            }
            Miapi.LOGGER.info("Loaded " + size + " Skins");
        });
    }

    public static void setup() {
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "skins/module", skins, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> SkinOptions.load(data)), 1.0f);
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "skins/tab", tabMap, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> SkinOptions.loadTabData(data)), 1.0f);
    }

    public static SkinTab getTag(String path) {
        return tabMap.getOrDefault(path, defaultTab);
    }

    public static void load(String data) {
        JsonObject element = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
        Skin.fromJson((JsonElement)element).forEach(skin -> {
            Map skinMap = skins.computeIfAbsent(skin.module, module -> new HashMap());
            skinMap.put(skin.path, skin);
        });
    }

    public static void loadTabData(String data) {
        JsonObject element = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
        SkinTab tab = SkinTab.fromJson((JsonElement)element);
        tabMap.put(tab.path, tab);
    }

    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext context) {
        String skin = buffer.m_130277_();
        ModularItemCache.clearUUIDFor(context.getItemstack());
        context.getInstance().moduleData.put("skin", skin);
        context.getInstance().getRoot().writeToItem(context.getItemstack());
        ModularItemCache.clearUUIDFor(context.getItemstack());
        return context.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext context) {
        return context.getInstance() != null && skins.get(context.getInstance().module) != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext context) {
        return new SkinGui(x, y, width, height, context.getItemstack(), context.getInstance(), context::craft, context::preview);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 371, 81, 512, 512, "miapi.ui.edit_option.hover.skin", this);
    }
}

