/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.edit_options.skins.TextureOptions;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.synergies.SynergyManager;
import smartin.miapi.registries.RegistryInventory;

public class Skin {
    public String path;
    public ItemModule module;
    public ModuleCondition condition;
    public SynergyManager.PropertyHolder propertyHolder;
    public TextureOptions textureOptions = new TextureOptions(new ResourceLocation("miapi", "textures/gui/skin/skin_button.png"), 100, 16, 3, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), 1, false);
    @Nullable
    public Component hoverDescription;

    public static List<Skin> fromJson(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<Skin> skins = new ArrayList<Skin>();
        Skin.getModules(element).forEach(itemModule -> {
            Skin skin = new Skin();
            skin.module = itemModule;
            skin.condition = ConditionManager.get(jsonObject.get("condition"));
            skin.path = jsonObject.get("path").getAsString();
            skin.propertyHolder = SynergyManager.getFrom((JsonElement)jsonObject, "skin for " + String.valueOf(skin.module) + " skinpath " + skin.path);
            skin.textureOptions = TextureOptions.fromJson(jsonObject.get("texture"), new ResourceLocation("miapi", "textures/gui/skin/skin_button.png"), 100, 16, 3, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255));
            if (jsonObject.has("hover")) {
                skin.hoverDescription = (Component)ExtraCodecs.f_252442_.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.getAsJsonObject("hover")).result().orElse(Component.m_237119_());
            }
            skins.add(skin);
        });
        return skins;
    }

    public static List<ItemModule> getModules(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<ItemModule> modules = new ArrayList<ItemModule>();
        if (jsonObject.has("module_tags")) {
            jsonObject.get("module_tags").getAsJsonArray().asList().forEach(jsonElement -> modules.addAll(TagProperty.getModulesWithTag(jsonElement.getAsString())));
        }
        if (jsonObject.has("module")) {
            JsonElement moduleElement = jsonObject.get("module");
            if (moduleElement.isJsonArray()) {
                jsonObject.get("module").getAsJsonArray().asList().forEach(jsonElement -> {
                    ItemModule itemModule = RegistryInventory.modules.get(jsonElement.getAsString());
                    if (itemModule != null) {
                        modules.add(itemModule);
                    }
                });
            } else {
                ItemModule itemModule = RegistryInventory.modules.get(jsonObject.get("module").getAsString());
                if (itemModule != null) {
                    modules.add(itemModule);
                }
            }
        }
        return modules;
    }
}

