/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.client.gui.crafting.crafter.CraftEditOption;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.network.Networking;

public class ReplaceOption
implements EditOption {
    @Nullable
    public static EditOption.EditContext unsafeEditContext;
    @Nullable
    public static CraftAction unsafeCraftAction;

    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        Material material;
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench());
        if (editContext.getLinkedInventory() == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = editContext.getLinkedInventory().m_8020_(0);
        action.setItem(itemStack);
        Container inventory = editContext.getLinkedInventory();
        boolean hasPreviewMaterial = false;
        if (PreviewManager.currentPreviewMaterial != null) {
            hasPreviewMaterial = true;
            inventory = new SimpleContainer(2);
            PreviewManager.currentPreviewMaterialStack.m_41773_();
            inventory.m_6836_(1, PreviewManager.currentPreviewMaterialStack);
        }
        action.linkInventory(inventory, 1);
        ItemStack preview = action.getPreview();
        if (editContext.getInstance() != null && !hasPreviewMaterial && (material = MaterialProperty.getMaterial(editContext.getInstance())) != null) {
            ArrayList<Integer> position = new ArrayList<Integer>();
            editContext.getInstance().calculatePosition(position);
            ItemModule.ModuleInstance root = ItemModule.getModules(preview);
            ItemModule.ModuleInstance editing = root.getPosition(position);
            if (MaterialProperty.getMaterial(editing) == null) {
                MaterialProperty.setMaterial(editing, material.getKey());
                editing.getRoot().writeToItem(preview);
            }
        }
        return preview;
    }

    public static void tryPreview() {
        if (unsafeEditContext != null && unsafeCraftAction != null) {
            try {
                unsafeEditContext.preview(unsafeCraftAction.toPacket(Networking.createBuffer()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void resetPreview() {
        unsafeEditContext = null;
        unsafeCraftAction = null;
    }

    @Override
    public ItemStack execute(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench());
        action.setItem(editContext.getLinkedInventory().m_8020_(0));
        action.linkInventory(editContext.getLinkedInventory(), 1);
        if (action.canPerform()) {
            return action.perform();
        }
        Miapi.LOGGER.warn("Could not previewStack Craft Action. This might indicate an exploit by " + editContext.getPlayer().m_20149_());
        return editContext.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext editContext) {
        return editContext.getSlot() != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext editContext) {
        unsafeEditContext = editContext;
        return new CraftEditOption(x, y, width, height, editContext);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        unsafeEditContext = null;
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 371, 25, 512, 512, "miapi.ui.edit_option.hover.replace", this);
    }
}

