/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.ClickAbleTextWidget;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

public class PropertyInjectionDev
implements EditOption {
    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext context) {
        String raw = buffer.m_130277_();
        assert (context.getInstance() != null);
        context.getInstance().moduleData.put("properties", raw);
        ItemStack stack1 = context.getItemstack().m_41777_();
        context.getInstance().getRoot().writeToItem(stack1);
        ModularItemCache.discardCache();
        return stack1;
    }

    @Override
    public boolean isVisible(EditOption.EditContext context) {
        return MiapiConfig.INSTANCE.server.other.developmentMode && context.getInstance() != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext context) {
        return new EditDevView(x, y, width, height, context.getItemstack(), context.getInstance(), context::craft);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 339, 81, 512, 512, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EditDevView
    extends InteractAbleWidget {
        public EditDevView(int x, int y, int width, int height, ItemStack stack, ItemModule.ModuleInstance moduleInstance, Consumer<FriendlyByteBuf> craft) {
            super(x, y, width, height, (Component)Component.m_237119_());
            MutableComponent text = Component.m_237113_((String)moduleInstance.moduleData.get("properties")).m_6881_();
            ClickAbleTextWidget textFieldWidget = new ClickAbleTextWidget(Minecraft.m_91087_().f_91062_, x + 5, y + 10, this.f_93618_ - 10, 20, (Component)text);
            textFieldWidget.m_94199_(Integer.MAX_VALUE);
            textFieldWidget.m_94186_(true);
            ScrollingTextWidget error = new ScrollingTextWidget(x + 5, y + 40, this.f_93618_ - 10, (Component)Component.m_237119_(), FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
            this.addChild(error);
            SimpleButton<Objects> craftButton = new SimpleButton<Objects>(this.m_252754_() + this.f_93618_ - 41, this.m_252907_() + this.f_93619_ - 11, 40, 10, (Component)Component.m_237113_((String)"Apply"), null, a -> {
                String raw = textFieldWidget.m_94155_();
                try {
                    JsonObject moduleJson;
                    boolean success = true;
                    if (raw != null && (moduleJson = (JsonObject)Miapi.gson.fromJson(raw, JsonObject.class)) != null) {
                        for (Map.Entry stringJsonElementEntry : moduleJson.entrySet()) {
                            ModuleProperty property = RegistryInventory.moduleProperties.get((String)stringJsonElementEntry.getKey());
                            try {
                                assert (property != null);
                                property.load(moduleInstance.module.getName(), (JsonElement)stringJsonElementEntry.getValue(), true);
                            }
                            catch (Exception e) {
                                error.setText(Component.m_130674_((String)e.getMessage()));
                                error.textColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
                                e.printStackTrace();
                                success = false;
                            }
                        }
                    }
                    if (success) {
                        FriendlyByteBuf buf = Networking.createBuffer();
                        buf.m_130070_(raw);
                        craft.accept(buf);
                        error.setText(Component.m_130674_((String)"success"));
                        error.textColor = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)255, (int)0);
                    }
                }
                catch (Exception all) {
                    error.setText(Component.m_130674_((String)all.getMessage()));
                    error.textColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
                    all.printStackTrace();
                }
            });
            this.addChild((GuiEventListener)textFieldWidget);
            this.addChild(craftButton);
        }
    }
}

