/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialCountCondition
implements ModuleCondition {
    public String material = "";
    public int count;

    public MaterialCountCondition() {
    }

    public MaterialCountCondition(String material, int count) {
        this.material = material;
        this.count = count;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        if (conditionContext instanceof ConditionManager.ModuleConditionContext) {
            ConditionManager.ModuleConditionContext moduleConditionContext = (ConditionManager.ModuleConditionContext)conditionContext;
            Map<ModuleProperty, JsonElement> propertyMap = moduleConditionContext.propertyMap;
            List<Component> reasons = moduleConditionContext.reasons;
            JsonElement data = propertyMap.get(MaterialProperty.property);
            if (data == null) {
                reasons.add((Component)Component.m_237115_((String)"miapi.condition.material.error"));
                return false;
            }
            Material material1 = MaterialProperty.getMaterial(data);
            if (material1 != null && MaterialProperty.getMaterial(data).getKey().equals(this.material) && this.getCount(moduleConditionContext.moduleInstance, material1) == this.count) {
                return true;
            }
            reasons.add((Component)Component.m_237115_((String)"miapi.condition.material.error"));
        }
        return false;
    }

    public int getCount(ItemModule.ModuleInstance moduleInstance, Material material) {
        if (moduleInstance != null) {
            List<ItemModule.ModuleInstance> moduleInstances = moduleInstance.getRoot().allSubModules().stream().filter(moduleInstance1 -> material.equals(MaterialProperty.getMaterial(moduleInstance1))).toList();
            for (int i = 0; i < moduleInstances.size(); ++i) {
                if (!moduleInstance.equals(moduleInstances.get(i))) continue;
                return i;
            }
        }
        return 0;
    }

    @Override
    public ModuleCondition load(JsonElement element) {
        return new MaterialCountCondition(element.getAsJsonObject().get("material").getAsString(), element.getAsJsonObject().get("count").getAsInt());
    }
}

