/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialCondition
implements ModuleCondition {
    public String material = "";
    public Component error = Component.m_237115_((String)"miapi.condition.material.error");

    public MaterialCondition() {
    }

    public MaterialCondition(String material) {
        this.material = material;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        if (conditionContext instanceof ConditionManager.ModuleConditionContext) {
            ConditionManager.ModuleConditionContext moduleConditionContext = (ConditionManager.ModuleConditionContext)conditionContext;
            Map<ModuleProperty, JsonElement> propertyMap = moduleConditionContext.propertyMap;
            List<Component> reasons = moduleConditionContext.reasons;
            JsonElement data = propertyMap.get(MaterialProperty.property);
            if (data == null) {
                reasons.add((Component)Component.m_237115_((String)"miapi.condition.material.error"));
                return false;
            }
            Material material1 = MaterialProperty.getMaterial(data);
            if (material1 != null && MaterialProperty.getMaterial(data).getKey().equals(this.material)) {
                return true;
            }
            reasons.add(this.error);
        }
        return false;
    }

    @Override
    public ModuleCondition load(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        MaterialCondition condition = new MaterialCondition(object.get("material").getAsString());
        condition.error = ModuleProperty.getText(object, "error", (Component)Component.m_237115_((String)"miapi.condition.material.error"));
        return condition;
    }
}

