/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.conditions.TrueCondition;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.MiapiRegistry;

public class ConditionManager {
    public static MiapiRegistry<ModuleCondition> moduleConditionRegistry = MiapiRegistry.getInstance(ModuleCondition.class);

    public static void setup() {
    }

    public static ModuleCondition get(JsonElement element) {
        if (element == null) {
            return new TrueCondition();
        }
        ModuleCondition condition = moduleConditionRegistry.get(element.getAsJsonObject().get("type").getAsString());
        assert (condition != null);
        return condition.load(element);
    }

    public static class ModuleConditionContext
    implements ConditionContext {
        @Nullable
        public ItemModule.ModuleInstance moduleInstance;
        @Nullable
        public BlockPos tablePos;
        @Nullable
        public Player player;
        @Nullable
        public Map<ModuleProperty, JsonElement> propertyMap;
        public List<Component> reasons;

        public ModuleConditionContext(@Nullable ItemModule.ModuleInstance moduleInstance, @Nullable BlockPos tablePos, @Nullable Player player, @Nullable Map<ModuleProperty, JsonElement> propertyMap, List<Component> reasons) {
            this.moduleInstance = moduleInstance;
            this.tablePos = tablePos;
            this.player = player;
            this.propertyMap = propertyMap;
            this.reasons = reasons;
        }

        @Override
        public ModuleConditionContext copy() {
            return new ModuleConditionContext(this.moduleInstance, this.tablePos, this.player, this.propertyMap, this.reasons);
        }

        @Override
        public List<Component> getReasons() {
            return this.reasons;
        }
    }

    public static interface ConditionContext {
        public ConditionContext copy();

        public List<Component> getReasons();
    }
}

