/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.model.ModelTransformer;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.item.modular.items.ModularSetableArmorMaterial;
import smartin.miapi.item.modular.items.ModularSetableToolMaterial;

public class ModularItemCache {
    protected static Map<String, CacheObjectSupplier> supplierMap = new HashMap<String, CacheObjectSupplier>();
    public static final long CACHE_SIZE = 1000L;
    public static final long CACHE_LIFETIME = 2L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.MINUTES;
    protected static final LoadingCache<ItemStack, Cache> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L, CACHE_LIFETIME_UNIT).build((CacheLoader)new CacheLoader<ItemStack, Cache>(){

        @NotNull
        public Cache load(@NotNull ItemStack key) {
            return new Cache(key);
        }
    });

    public static void setSupplier(String key, CacheObjectSupplier supplier) {
        supplierMap.put(key, supplier);
    }

    @Nullable
    public static <T> T getRaw(ItemStack stack, String key) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof VisualModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            return (T)itemCache.get(key);
        }
        return null;
    }

    public static <T> T get(ItemStack stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof ModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            Object object = itemCache.get(key);
            if (object == null) {
                return fallback;
            }
            return (T)object;
        }
        return fallback;
    }

    public static <T> T getVisualOnlyCache(ItemStack stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof VisualModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            Object object = itemCache.get(key);
            if (object == null) {
                return fallback;
            }
            return (T)object;
        }
        return fallback;
    }

    public static void discardCache() {
        ((MiapiEvents.ReloadEvent)MiapiEvents.CACHE_CLEAR_EVENT.invoker()).onReload(Environment.isClient());
        cache.cleanUp();
        cache.invalidateAll();
        ModularSetableArmorMaterial.ITEMSTACK_CACHE.clear();
        ModularSetableToolMaterial.ITEMSTACK_CACHE.clear();
        if (Environment.isClient()) {
            ModelTransformer.clearCaches();
            MaterialSpriteManager.clear();
        }
    }

    public static void clearUUIDFor(ItemStack stack) {
        if (stack.m_41720_() instanceof VisualModularItem && stack.m_41782_()) {
            cache.invalidate((Object)stack);
        }
    }

    protected static Cache find(ItemStack stack) {
        try {
            Cache cacheEntry = (Cache)cache.get((Object)stack, () -> new Cache(stack));
            if (cacheEntry.isValid(stack)) {
                return cacheEntry;
            }
            cache.invalidate((Object)stack);
            return (Cache)cache.get((Object)stack, () -> new Cache(stack));
        }
        catch (ExecutionException ignored) {
            Cache cache1 = new Cache(stack);
            cache.put((Object)stack, (Object)cache1);
            return cache1;
        }
    }

    protected static class Cache {
        protected Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        public ItemStack stack;

        public Cache(ItemStack stack) {
            this.stack = stack;
        }

        public boolean isValid(ItemStack itemStack) {
            return true;
        }

        public void set(String key, Object object) {
            this.map.put(key, object);
        }

        public Object get(String key) {
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            CacheObjectSupplier supplier = supplierMap.get(key);
            if (supplier != null) {
                Object cached = supplier.apply(this.stack);
                if (cached != null) {
                    this.map.put(key, cached);
                }
                return cached;
            }
            return null;
        }
    }

    public static interface CacheObjectSupplier
    extends Function<ItemStack, Object> {
        @Override
        public Object apply(ItemStack var1);
    }
}

