/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.abilities.util.ItemUseAbility;

public interface ItemUseMinHoldAbility<T>
extends ItemUseAbility<T> {
    default public int minHoldTimeDefault() {
        return 0;
    }

    default public int getMinHoldTime(ItemStack itemStack) {
        return this.getAbilityContext(itemStack).getInt("min_hold", this.minHoldTimeDefault());
    }

    @Override
    default public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (this.finishedMinHold(stack, world, user, remainingUseTicks)) {
            this.onStoppedUsingAfter(stack, world, user, remainingUseTicks);
        }
    }

    default public boolean finishedMinHold(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        return this.getMaxUseTime(stack) - remainingUseTicks > this.getMinHoldTime(stack);
    }

    default public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }
}

