/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.google.gson.JsonObject;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.AbilityMangerProperty;

public interface ItemUseAbility<T> {
    public boolean allowedOnItem(ItemStack var1, Level var2, Player var3, InteractionHand var4, ItemAbilityManager.AbilityHitContext var5);

    default public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.NONE;
    }

    public int getMaxUseTime(ItemStack var1);

    public InteractionResultHolder<ItemStack> use(Level var1, Player var2, InteractionHand var3);

    default public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        return stack;
    }

    default public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }

    default public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
    }

    default public InteractionResult useOnEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    default public boolean isUsedOnRelease(ItemStack itemStack) {
        return false;
    }

    default public InteractionResult useOnBlock(UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
    }

    default public AbilityMangerProperty.AbilityContext getAbilityContext(ItemStack itemStack) {
        AbilityMangerProperty.AbilityContext context1;
        String key = ItemAbilityManager.useAbilityRegistry.findKey(this);
        if (key != null && (context1 = AbilityMangerProperty.getContext(itemStack, key)) != null) {
            return context1;
        }
        return new AbilityMangerProperty.AbilityContext(new JsonObject(), ItemModule.getModules(itemStack), itemStack);
    }

    default public T fromJson(JsonObject jsonObject) {
        return null;
    }

    default public T getSpecialContext(ItemStack itemStack, T defaultValue) {
        return ModularItemCache.get(itemStack, AbilityMangerProperty.KEY + "_" + ItemAbilityManager.useAbilityRegistry.findKey(this), defaultValue);
    }
}

