/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.block;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.abilities.block.InflictCooldownBlockingProperty;
import smartin.miapi.modules.abilities.block.MaxHoldBlockingProperty;
import smartin.miapi.modules.abilities.block.ReflectDamageBlockingProperty;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.BlockProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.registries.RegistryInventory;

public class ParryBlock
extends EntityAttributeAbility<ParryContext> {
    public static String KEY = "parry_block";
    UUID attributeUUID = UUID.fromString("4e91990e-4774-11ee-be67-0242ac120002");

    public ParryBlock() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                MutableComponent raw = Component.m_237115_((String)"miapi.ability.parry_block.lore");
                texts.add(raw);
            }
            return texts;
        });
        MiapiEvents.LIVING_HURT.register((Object)new MiapiEvents.LivingHurt(){

            /*
             * Unable to fully structure code
             */
            @Override
            public EventResult hurt(MiapiEvents.LivingHurtEvent event) {
                block2: {
                    block3: {
                        var3_2 = event.defender;
                        if (!(var3_2 instanceof Player) || (activeItem = (defender = (Player)var3_2).m_21211_()) == null || !(ItemAbilityManager.getAbility(activeItem) instanceof ParryBlock) || (parryContext = ParryBlock.this.getContext(activeItem)) == null) break block2;
                        defender.m_36335_().m_41524_(activeItem.m_41720_(), ((Integer)parryContext.cooldown.evaluate(parryContext.moduleInstance)).intValue());
                        var6_5 = event.damageSource.m_7639_();
                        if (!(var6_5 instanceof LivingEntity)) break block3;
                        attacker = (LivingEntity)var6_5;
                        cd = (int)((double)((Integer)parryContext.cooldownAttackerWeapon.evaluate(parryContext.moduleInstance)).intValue() + InflictCooldownBlockingProperty.property.getValueSafe(activeItem));
                        var8_8 = event.damageSource.m_7639_();
                        if (!(var8_8 instanceof Player)) ** GOTO lbl-1000
                        playerEntity = (Player)var8_8;
                        if (attacker.m_21205_() != null && !attacker.m_21205_().m_41619_()) {
                            playerEntity.m_36335_().m_41524_(attacker.m_21205_().m_41720_(), cd);
                        } else lbl-1000:
                        // 2 sources

                        {
                            instance = new MobEffectInstance(RegistryInventory.stunEffect, cd);
                            attacker.m_7292_(instance);
                        }
                        returnPercent = (ReflectDamageBlockingProperty.property.getValueSafe(activeItem) + (double)((Double)parryContext.damageReturnPercent.evaluate(parryContext.moduleInstance)).floatValue()) / 100.0;
                        attacker.m_6469_(defender.m_269291_().m_269075_(defender), (float)((double)event.amount * returnPercent));
                    }
                    BuiltInRegistries.f_256894_.m_6612_(parryContext.sound).ifPresent((Consumer<SoundEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$hurt$0(net.minecraft.world.entity.player.Player smartin.miapi.modules.abilities.block.ParryBlock$ParryContext net.minecraft.sounds.SoundEvent ), (Lnet/minecraft/sounds/SoundEvent;)V)((Player)defender, (ParryContext)parryContext));
                    return EventResult.interruptDefault();
                }
                return EventResult.pass();
            }

            private static /* synthetic */ void lambda$hurt$0(Player defender, ParryContext parryContext, SoundEvent sound) {
                defender.m_5496_(sound, ((Double)parryContext.volume.evaluate(parryContext.moduleInstance)).floatValue(), ((Double)parryContext.pitch.evaluate(parryContext.moduleInstance)).floatValue());
            }
        });
    }

    @Override
    protected Multimap<Attribute, AttributeModifier> getAttributes(ItemStack itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        double value = BlockProperty.property.getValueSafe(itemStack);
        value = ParryBlock.calculate(value);
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        ParryContext context = this.getContext(itemStack);
        if (context != null) {
            return (Integer)context.maxHoldTime.evaluate(context.moduleInstance) + (int)MaxHoldBlockingProperty.property.getValueSafe(itemStack);
        }
        return 0;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand);
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        ParryContext parryContext = this.getContext(stack);
        if (parryContext != null && user instanceof Player) {
            Player player = (Player)user;
            player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)parryContext.cooldownMissTime.evaluate(parryContext.moduleInstance)).intValue());
        }
        return super.finishUsing(stack, world, user);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user);
    }

    public void setAnimation(Player p, InteractionHand hand) {
        if (p instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)p;
            ServerPoseFacet facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)player);
            ItemStack itemStack = p.m_21120_(hand);
            ParryContext context = this.getContext(itemStack);
            if (facet != null && context != null) {
                facet.set(context.poseId.toString(), player, hand);
            }
        }
    }

    public void resetAnimation(LivingEntity entity) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)entity))) != null) {
            facet.reset(player);
        }
    }

    @Nullable
    public ParryContext getContext(ItemStack itemStack) {
        AbilityMangerProperty.AbilityContext asd = this.getAbilityContext(itemStack);
        JsonObject object = asd.contextJson;
        if (object != null) {
            ParryContext context = this.fromJson(object);
            context.moduleInstance = asd.contextInstance;
            return this.fromJson(object);
        }
        return null;
    }

    @Override
    public ParryContext fromJson(JsonObject jsonObject) {
        Codec PARRY_CONTEXT_CODEC = AutoCodec.of(ParryContext.class).codec();
        return (ParryContext)((Pair)PARRY_CONTEXT_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().get()).getFirst();
    }

    public static class ParryContext {
        @AutoCodec.Name(value="pose_id")
        @CodecBehavior.Optional
        public ResourceLocation poseId = new ResourceLocation("miapi", "medium_shield_block");
        @AutoCodec.Name(value="sound")
        @CodecBehavior.Optional
        public ResourceLocation sound = new ResourceLocation("minecraft:block.iron_trapdoor.close");
        @AutoCodec.Name(value="sound_pitch")
        @CodecBehavior.Optional
        public StatResolver.DoubleFromStat pitch = new StatResolver.DoubleFromStat(1.0);
        @AutoCodec.Name(value="sound_volume")
        @CodecBehavior.Optional
        public StatResolver.DoubleFromStat volume = new StatResolver.DoubleFromStat(1.0);
        @AutoCodec.Name(value="max_hold_time")
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat maxHoldTime = new StatResolver.IntegerFromStat(20);
        @AutoCodec.Name(value="damage_return_percent")
        @CodecBehavior.Optional
        public StatResolver.DoubleFromStat damageReturnPercent = new StatResolver.DoubleFromStat(0.0);
        @AutoCodec.Name(value="cooldown_attacker_weapon")
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldownAttackerWeapon = new StatResolver.IntegerFromStat(0);
        @AutoCodec.Name(value="cooldown")
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldown = new StatResolver.IntegerFromStat(40);
        @AutoCodec.Name(value="cooldown_miss_time")
        @CodecBehavior.Optional
        public StatResolver.IntegerFromStat cooldownMissTime = new StatResolver.IntegerFromStat(40);
        @AutoCodec.Ignored
        public ItemModule.ModuleInstance moduleInstance;
    }
}

