/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.redpxnda.nucleus.network.clientbound.ParticleCreationPacket;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.abilities.util.AttackUtil;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.HeavyAttackProperty;
import smartin.miapi.modules.properties.LoreProperty;

public class HeavyAttackAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    public HeavyAttackAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                texts.add(Component.m_237115_((String)"miapi.ability.heavy_attack.lore"));
            }
            return texts;
        });
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return HeavyAttackProperty.property.hasHeavyAttack(itemStack) || this.getAbilityContext(itemStack).getDouble("damage", 0.0) != 0.0;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.m_36335_().m_41519_(user.m_21120_(hand).m_41720_())) {
            return InteractionResultHolder.m_19098_((Object)user.m_21120_(hand));
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        double cooldown;
        double minHold;
        double range;
        double sweeping;
        double damage;
        HeavyAttackProperty.HeavyAttackHolder heavyAttackJson = HeavyAttackProperty.property.get(stack);
        AbilityMangerProperty.AbilityContext context = this.getAbilityContext(stack);
        if (heavyAttackJson != null) {
            damage = context.getDouble("damage", heavyAttackJson.damage);
            sweeping = context.getDouble("sweeping", heavyAttackJson.sweeping);
            range = context.getDouble("range", heavyAttackJson.range);
            minHold = context.getDouble("minHold", heavyAttackJson.minHold);
            cooldown = context.getDouble("cooldown", heavyAttackJson.cooldown);
        } else {
            damage = context.getDouble("damage", 1.0);
            sweeping = context.getDouble("sweeping", 0.0);
            range = context.getDouble("range", 3.5);
            minHold = context.getDouble("minHold", 20.0);
            cooldown = context.getDouble("cooldown", 20.0);
        }
        if (user instanceof Player) {
            Entity target2;
            EntityHitResult entityHitResult;
            Player player = (Player)user;
            if ((double)(this.getMaxUseTime(stack) - remainingUseTicks) > minHold && (entityHitResult = AttackUtil.raycastFromPlayer(range, player)) != null && (target2 = entityHitResult.m_82443_()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)target2;
                ((LivingEntityAccessor)player).attacking(target);
                float basedamage = (float)player.m_21133_(Attributes.f_22281_);
                damage = (double)(EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)target.m_6336_()) + basedamage) * damage;
                AttackUtil.performAttack(player, target, (float)damage, true);
                if (sweeping > 0.0) {
                    AttackUtil.performSweeping(player, target, (float)sweeping, (float)damage);
                }
                player.m_6674_(player.m_7655_());
                player.m_36335_().m_41524_(stack.m_41720_(), (int)cooldown);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    if (heavyAttackJson != null && heavyAttackJson.particleEffect != null) {
                        ParticleCreationPacket particleCreationPacket = new ParticleCreationPacket(heavyAttackJson.particleEffect, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
                        particleCreationPacket.send(serverWorld);
                    }
                }
            }
        }
    }
}

