/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.CrossbowProperty;

public class CrossbowAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    private boolean charged = false;
    private boolean loaded = false;
    private static final String PROJECTILE_KEY = "ChargedProjectiles";

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        CrossbowProperty.CrossbowAbilityConfig config = CrossbowProperty.getConfig(itemStack);
        Miapi.LOGGER.warn("testing if ALLOWED");
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.CROSSBOW;
    }

    private static float getPullProgress(int useTicks, ItemStack stack) {
        float f = (float)useTicks / (float)CrossbowAbility.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @Override
    public int getMaxUseTime(ItemStack stack) {
        return CrossbowAbility.getPullTime(stack) + 3;
    }

    public static int getPullTime(ItemStack itemStack) {
        CrossbowProperty.CrossbowAbilityConfig config = CrossbowProperty.getConfig(itemStack);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        Miapi.LOGGER.warn("USE");
        ItemStack itemStack = user.m_21120_(hand);
        CrossbowProperty.CrossbowAbilityConfig config = CrossbowProperty.getConfig(itemStack);
        if (CrossbowAbility.isCharged(itemStack)) {
            CrossbowAbility.shootAll(world, (LivingEntity)user, hand, itemStack, CrossbowAbility.getSpeed(itemStack), 1.0f);
            CrossbowAbility.setCharged(itemStack, false);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (!this.getProjectile(config.ammoPredicate, user).m_41619_()) {
            if (!CrossbowAbility.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        Miapi.LOGGER.warn("USE FAIL");
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public ItemStack getProjectile(Predicate<ItemStack> predicate, Player entity) {
        ItemStack itemStack = ProjectileWeaponItem.m_43010_((LivingEntity)entity, predicate);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        for (int i = 0; i < entity.m_150109_().m_6643_(); ++i) {
            ItemStack itemStack2 = entity.m_150109_().m_8020_(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return entity.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_;
    }

    private static float getSpeed(ItemStack stack) {
        return CrossbowAbility.hasProjectile(stack, Items.f_42688_) ? 1.6f : 3.15f;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        Miapi.LOGGER.warn("Stop Using");
        int i = this.getMaxUseTime(stack) - remainingUseTicks;
        float f = CrossbowAbility.getPullProgress(i, stack);
        Miapi.LOGGER.warn(String.valueOf(f));
        if (f >= 1.0f && !CrossbowAbility.isCharged(stack) && CrossbowAbility.loadProjectiles(user, stack)) {
            CrossbowAbility.setCharged(stack, true);
            SoundSource soundCategory = user instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11841_, soundCategory, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean loadProjectiles(LivingEntity shooter, ItemStack projectile) {
        Miapi.LOGGER.warn("trying to load Projectile");
        i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)projectile);
        v0 = j = i == 0 ? 1 : 3;
        if (!(shooter instanceof Player)) ** GOTO lbl-1000
        playerEntity = (Player)shooter;
        if (playerEntity.m_150110_().f_35937_) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        bl = v1;
        itemStack = shooter.m_6298_(projectile);
        itemStack2 = itemStack.m_41777_();
        for (k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.m_41777_();
            }
            if (itemStack.m_41619_() && bl) {
                itemStack = new ItemStack((ItemLike)Items.f_42412_);
                itemStack2 = itemStack.m_41777_();
            }
            if (CrossbowAbility.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            Miapi.LOGGER.warn("failed to load Projectile");
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity shooter, ItemStack crossbow, ItemStack projectile, boolean simulated, boolean creative) {
        ItemStack itemStack;
        boolean bl;
        if (projectile.m_41619_()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.m_41720_() instanceof ArrowItem;
        if (!(bl || creative || simulated)) {
            itemStack = projectile.m_41620_(1);
            if (projectile.m_41619_() && shooter instanceof Player) {
                Player player = (Player)shooter;
                player.m_150109_().m_36057_(projectile);
            }
        } else {
            itemStack = projectile.m_41777_();
        }
        CrossbowAbility.putProjectile(crossbow, itemStack);
        return true;
    }

    public static boolean isCharged(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        return nbtCompound != null && nbtCompound.m_128471_("Charged");
    }

    public static void setCharged(ItemStack stack, boolean charged) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128379_("Charged", charged);
    }

    private static void putProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundTag nbtCompound = crossbow.m_41784_();
        ListTag nbtList = nbtCompound.m_128425_(PROJECTILE_KEY, 9) ? nbtCompound.m_128437_(PROJECTILE_KEY, 10) : new ListTag();
        CompoundTag nbtCompound2 = new CompoundTag();
        projectile.m_41739_(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.m_128365_(PROJECTILE_KEY, (Tag)nbtList);
    }

    private static List<ItemStack> getProjectiles(ItemStack crossbow) {
        ListTag nbtList;
        ArrayList list = Lists.newArrayList();
        CompoundTag nbtCompound = crossbow.m_41783_();
        if (nbtCompound != null && nbtCompound.m_128425_(PROJECTILE_KEY, 9) && (nbtList = nbtCompound.m_128437_(PROJECTILE_KEY, 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag nbtCompound2 = nbtList.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)nbtCompound2));
            }
        }
        return list;
    }

    private static void clearProjectiles(ItemStack crossbow) {
        CompoundTag nbtCompound = crossbow.m_41783_();
        if (nbtCompound != null) {
            ListTag nbtList = nbtCompound.m_128437_(PROJECTILE_KEY, 9);
            nbtList.clear();
            nbtCompound.m_128365_(PROJECTILE_KEY, (Tag)nbtList);
        }
    }

    public static boolean hasProjectile(ItemStack crossbow, Item projectile) {
        return CrossbowAbility.getProjectiles(crossbow).stream().anyMatch(s -> s.m_150930_(projectile));
    }

    private static void shoot(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.f_46443_) {
            AbstractArrow projectileEntity;
            boolean bl = projectile.m_150930_(Items.f_42688_);
            if (bl) {
                projectileEntity = new FireworkRocketEntity(world, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectileEntity = CrossbowAbility.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowUser = (CrossbowAttackMob)shooter;
                crossbowUser.m_5811_(crossbowUser.m_5448_(), crossbow, (Projectile)projectileEntity, simulated);
            } else {
                Vec3 vec3d = shooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                Vec3 vec3d2 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec3d2.m_252839_().rotate((Quaternionfc)quaternionf);
                projectileEntity.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.m_41622_(bl ? 3 : 1, shooter, e -> e.m_21190_(hand));
            world.m_7967_((Entity)projectileEntity);
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static AbstractArrow createArrow(Level world, LivingEntity entity, ItemStack crossbow, ItemStack arrow) {
        ArrowItem arrowItem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
        AbstractArrow persistentProjectileEntity = arrowItem.m_6394_(world, arrow, entity);
        if (entity instanceof Player) {
            persistentProjectileEntity.m_36762_(true);
        }
        persistentProjectileEntity.m_36740_(SoundEvents.f_11840_);
        persistentProjectileEntity.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            persistentProjectileEntity.m_36767_((byte)i);
        }
        return persistentProjectileEntity;
    }

    /*
     * Unable to fully structure code
     */
    public static void shootAll(Level world, LivingEntity entity, InteractionHand hand, ItemStack stack, float speed, float divergence) {
        list = CrossbowAbility.getProjectiles(stack);
        fs = CrossbowAbility.getSoundPitches(entity.m_217043_());
        for (i = 0; i < list.size(); ++i) {
            itemStack = list.get(i);
            if (!(entity instanceof Player)) ** GOTO lbl-1000
            playerEntity = (Player)entity;
            if (playerEntity.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = bl = false;
            }
            if (itemStack.m_41619_()) continue;
            if (i == 0) {
                CrossbowAbility.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                CrossbowAbility.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CrossbowAbility.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
        }
        CrossbowAbility.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(RandomSource random) {
        boolean bl = random.m_188499_();
        return new float[]{1.0f, CrossbowAbility.getSoundPitch(bl, random), CrossbowAbility.getSoundPitch(!bl, random)};
    }

    private static float getSoundPitch(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(Level world, LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            if (!world.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayerEntity, stack);
            }
            serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        CrossbowAbility.clearProjectiles(stack);
    }

    @Override
    public void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent soundEvent = this.getQuickChargeSound(i);
            SoundEvent soundEvent2 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(stack.m_41779_() - remainingUseTicks) / (float)CrossbowAbility.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), soundEvent2, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    private SoundEvent getQuickChargeSound(int stage) {
        return switch (stage) {
            case 1 -> SoundEvents.f_11844_;
            case 2 -> SoundEvents.f_11845_;
            case 3 -> SoundEvents.f_11846_;
            default -> SoundEvents.f_11843_;
        };
    }
}

