/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.abilities.util.AttackUtil;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.CircleAttackProperty;

public class CircleAttackAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return CircleAttackProperty.property.hasCircleAttack(itemStack);
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (user.m_36335_().m_41519_(user.m_21120_(hand).m_41720_())) {
            return InteractionResultHolder.m_19098_((Object)user.m_21120_(hand));
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        CircleAttackProperty.CircleAttackJson json = CircleAttackProperty.property.get(stack);
        double damage = json.damage;
        double range = json.range;
        double minHold = json.minHold;
        double cooldown = json.cooldown;
        if (user instanceof Player) {
            Player player = (Player)user;
            if ((double)(this.getMaxUseTime(stack) - remainingUseTicks) > minHold) {
                damage = (double)((float)player.m_21133_(Attributes.f_22281_)) * damage;
                AttackUtil.performSweeping(player, (LivingEntity)player, (float)range, (float)damage);
                player.m_6674_(player.m_7655_());
                player.m_36335_().m_41524_(stack.m_41720_(), (int)cooldown);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    json.particles.forEach(particleJson -> {
                        double radius = range * particleJson.rangePercent;
                        double angleIncrement = 2.0 * Math.asin(0.5 / radius);
                        for (double angle = 0.0; angle < Math.PI * 2; angle += angleIncrement) {
                            double offsetX = radius * Math.sin(angle);
                            double offsetZ = radius * Math.cos(angle);
                            double particleX = player.m_20185_() + offsetX;
                            double particleY = player.m_20227_(0.5);
                            double particleZ = player.m_20189_() + offsetZ;
                            particleJson.particleType = (ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(particleJson.particle));
                            ParticleType patt3509$temp = particleJson.particleType;
                            if (!(patt3509$temp instanceof SimpleParticleType)) continue;
                            SimpleParticleType particle = (SimpleParticleType)patt3509$temp;
                            serverWorld.m_8767_((ParticleOptions)particle, particleX, particleY, particleZ, particleJson.count, 0.0, 0.0, 0.0, 1.0);
                        }
                    });
                }
            }
        }
    }
}

