/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.modules.abilities.util.EntityAttributeAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.BlockPoseProperty;
import smartin.miapi.modules.properties.BlockProperty;
import smartin.miapi.modules.properties.LoreProperty;

public class BlockAbility
extends EntityAttributeAbility {
    UUID attributeUUID = UUID.fromString("3e91990e-4774-11ee-be56-0242ac120002");

    public BlockAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                MutableComponent raw = Component.m_237115_((String)"miapi.ability.block.lore");
                texts.add(raw);
            }
            return texts;
        });
    }

    @Override
    protected Multimap<Attribute, AttributeModifier> getAttributes(ItemStack itemStack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        double value = BlockProperty.property.getValueSafe(itemStack);
        value = BlockAbility.calculate(value);
        multimap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(this.attributeUUID, "miapi-block", -(value / 2.0) / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        multimap.put((Object)AttributeRegistry.DAMAGE_RESISTANCE, (Object)new AttributeModifier(this.attributeUUID, "miapi-block", value, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public static double calculate(double value) {
        return 160.0 / (1.0 + Math.exp(-value / 50.0)) - 80.0;
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        this.setAnimation(user, hand);
        return super.use(world, user, hand);
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        return super.finishUsing(stack, world, user);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.resetAnimation(user);
        super.onStoppedUsingAfter(stack, world, user, remainingUseTicks);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        this.resetAnimation(user);
        super.onStoppedHolding(stack, world, user);
    }

    public void setAnimation(Player p, InteractionHand hand) {
        if (p instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)p;
            ServerPoseFacet facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)player);
            ItemStack itemStack = p.m_21120_(hand);
            if (facet != null) {
                facet.set(BlockPoseProperty.poseProperty.getPoseId(itemStack), player, hand);
            }
        }
    }

    public void resetAnimation(LivingEntity entity) {
        ServerPlayer player;
        ServerPoseFacet facet;
        if (entity instanceof ServerPlayer && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)(player = (ServerPlayer)entity))) != null) {
            facet.reset(player);
        }
    }
}

