/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.AbilityMangerProperty;

public class AreaHarvestReplant
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    public static String KEY = "area_harvest_ability";

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        if (abilityHitContext.hitEntity() == null && abilityHitContext.hitResult() != null) {
            BlockState state = abilityHitContext.hitResult().m_43725_().m_8055_(abilityHitContext.hitResult().m_8083_());
            return this.isGrown(state);
        }
        return false;
    }

    public boolean isGrown(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52307_(state);
        }
        return false;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.BRUSH;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        return 10;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return null;
    }

    @Override
    public InteractionResult useOnBlock(UseOnContext context) {
        Player player;
        ItemStack itemStack = context.m_43722_();
        if (!context.m_43725_().m_5776_() && (player = context.m_43723_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int blocksHarvested = 0;
            AbilityMangerProperty.AbilityContext abilityContext = this.getAbilityContext(itemStack);
            int range = abilityContext.getInt("block_range", 1);
            BlockState state = context.m_43725_().m_8055_(context.m_8083_());
            BlockPos origin = context.m_8083_();
            if (this.isGrown(state)) {
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        Block block;
                        BlockPos currentPos = origin.m_7918_(x, 0, y);
                        BlockState blockState = context.m_43725_().m_8055_(currentPos);
                        if (!this.isGrown(blockState) || !((block = blockState.m_60734_()) instanceof CropBlock)) continue;
                        CropBlock cropBlock = (CropBlock)block;
                        block = context.m_43725_();
                        if (!(block instanceof ServerLevel)) continue;
                        ServerLevel serverWorld = (ServerLevel)block;
                        BlockEntity blockEntity = blockState.m_155947_() ? context.m_43725_().m_7702_(currentPos) : null;
                        List stacks = Block.m_49874_((BlockState)blockState, (ServerLevel)serverWorld, (BlockPos)currentPos, (BlockEntity)blockEntity, (Entity)serverPlayer, (ItemStack)itemStack);
                        serverWorld.m_46597_(currentPos, cropBlock.m_52289_(0));
                        stacks.forEach(stack -> serverPlayer.m_150109_().m_150079_(stack));
                        ++blocksHarvested;
                    }
                }
            }
            itemStack.m_220157_(blocksHarvested, context.m_43725_().m_213780_(), serverPlayer);
            return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
        }
        return InteractionResult.FAIL;
    }
}

