/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Map;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.attributes.ElytraAttributes;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.properties.EquipmentSlotProperty;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @ModifyReturnValue(method={"getPreferredEquipmentSlot"}, at={@At(value="RETURN")})
    private static EquipmentSlot miapi$onGetPreferredEquipmentSlot(EquipmentSlot original, ItemStack stack) {
        EquipmentSlot slot;
        if (stack.m_41720_() instanceof ModularItem && (slot = EquipmentSlotProperty.getSlot(stack)) != null) {
            return slot;
        }
        return original;
    }

    @ModifyReturnValue(method={"Lnet/minecraft/entity/LivingEntity;getEquipmentChanges()Ljava/util/Map;"}, at={@At(value="RETURN")})
    private Map<EquipmentSlot, ItemStack> miapi$onEquipChange(Map<EquipmentSlot, ItemStack> original) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player) {
            Player entity = (Player)player;
            Map<EquipmentSlot, ItemStack> map = original;
            if (map != null && !map.isEmpty()) {
                ((MiapiEvents.PlayerEquip)MiapiEvents.PLAYER_EQUIP_EVENT.invoker()).equip(entity, map);
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"teleport(DDDZ)Z"}, at={@At(value="RETURN")})
    private boolean miapi$optionalTeleportBlockEffect(boolean original, double x, double y, double z, boolean particleEffects) {
        LivingEntity entity = (LivingEntity)this;
        if (particleEffects && MiapiConfig.INSTANCE.server.other.blockAllTeleportsEffect && entity.m_21023_(RegistryInventory.teleportBlockEffect)) {
            return false;
        }
        return original;
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder miapi$addAttributes(AttributeSupplier.Builder builder) {
        if (builder != null) {
            AttributeRegistry.entityAttributeMap.forEach((id, attribute) -> builder.m_22266_(attribute));
            ((MiapiEvents.LivingEntityAttributeBuild)MiapiEvents.LIVING_ENTITY_ATTRIBUTE_BUILD_EVENT.invoker()).build(builder);
        }
        return builder;
    }

    @Inject(method={"Lnet/minecraft/entity/LivingEntity;tick()V"}, at={@At(value="TAIL")}, cancellable=true)
    private void miapi$tickShieldingArmor(CallbackInfo ci) {
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void miapi$adjustElytraSpeed(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        ElytraAttributes.movementUpdate(livingEntity);
        ((MiapiEvents.LivingEntityTickEvent)MiapiEvents.LIVING_ENTITY_TICK_END.invoker()).tick(livingEntity);
    }

    @Inject(method={"tickMovement()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$stopMovementTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.m_21023_(RegistryInventory.stunEffect)) {
            if (livingEntity instanceof Player) {
                Player playerEntity = (Player)livingEntity;
                if (!playerEntity.m_21023_(MobEffects.f_19610_)) {
                    // empty if block
                }
            } else {
                ci.cancel();
            }
        }
    }
}

