/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RarityProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.ToolOrWeaponProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;

public class ModularWeapon
extends Item
implements PlatformModularItemMethods,
ModularItem {
    public ModularWeapon() {
        this(new Item.Properties(), true);
    }

    public ModularWeapon(Item.Properties settings, boolean withDefaultSettings) {
        super(withDefaultSettings ? settings.m_41487_(1).m_41503_(500) : settings);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.m_41773_()) / (float)ModularItem.getDurability(stack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_8120_(ItemStack itemStack) {
        return true;
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Component m_7626_(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (ToolOrWeaponProperty.isWeapon(stack)) {
            stack.m_41622_(1, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        } else {
            stack.m_41622_(2, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!world.f_46443_ && state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            if (ToolOrWeaponProperty.isWeapon(stack)) {
                stack.m_41622_(2, miner, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            } else {
                stack.m_41622_(1, miner, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return MiningLevelProperty.canMine(state, world, pos, miner);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return MiningLevelProperty.getMiningSpeedMultiplier(stack, state);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return ItemAbilityManager.getUseAction(stack, () -> super.m_6164_(stack));
    }

    public int m_8105_(ItemStack stack) {
        return ItemAbilityManager.getMaxUseTime(stack, () -> super.m_8105_(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        return ItemAbilityManager.use(world, user, hand, () -> super.m_7203_(world, user, hand));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ItemAbilityManager.onStoppedUsing(stack, world, user, remainingUseTicks, () -> super.m_5551_(stack, world, user, remainingUseTicks));
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        return ItemAbilityManager.finishUsing(stack, world, user, () -> super.m_5922_(stack, world, user));
    }

    public Rarity m_41460_(ItemStack stack) {
        return RarityProperty.getRarity(stack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        ItemAbilityManager.usageTick(world, user, stack, remainingUseTicks, () -> super.m_5929_(world, user, stack, remainingUseTicks));
    }

    public boolean m_41463_(ItemStack stack) {
        return ItemAbilityManager.isUsedOnRelease(stack, () -> super.m_41463_(stack));
    }

    public InteractionResult m_6880_(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        return ItemAbilityManager.useOnEntity(stack, user, entity, hand, () -> super.m_6880_(stack, user, entity, hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return ItemAbilityManager.useOnBlock(context, () -> super.m_6225_(context));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        LoreProperty.appendLoreTop(stack, world, tooltip, context);
    }
}

