/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import smartin.miapi.Environment;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.CustomDrawTimeItem;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.item.modular.items.ModularBow;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.IsCrossbowShootAble;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RarityProperty;
import smartin.miapi.modules.properties.RepairPriority;

public class ModularCrossbow
extends CrossbowItem
implements PlatformModularItemMethods,
ModularItem,
CustomDrawTimeItem {
    public ModularCrossbow(Item.Properties settings) {
        super(settings.m_41487_(1).m_41503_(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ModularCrossbow() {
        super(new Item.Properties().m_41487_(1).m_41503_(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAnimations() {
        ModularModelPredicateProvider.registerModelOverride((Item)this, new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : ModularCrossbow.getPullProgress(stack.m_41779_() - entity.m_21212_(), stack);
        });
        ModularModelPredicateProvider.registerModelOverride((Item)this, new ResourceLocation("pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ModularModelPredicateProvider.registerModelOverride((Item)this, new ResourceLocation("charged"), (stack, world, entity, seed) -> entity != null && ModularCrossbow.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public Rarity m_41460_(ItemStack stack) {
        return RarityProperty.getRarity(stack);
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.m_41773_()) / (float)ModularItem.getDurability(stack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_8120_(ItemStack itemStack) {
        return true;
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Component m_7626_(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public int m_6473_() {
        return 1;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i = this.m_8105_(stack) - remainingUseTicks;
        float f = ModularCrossbow.getPullProgress(i, stack);
        if (f >= 1.0f && !ModularCrossbow.m_40932_((ItemStack)stack) && ModularCrossbow.loadProjectiles(user, stack)) {
            ModularCrossbow.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundCategory = user instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            world.m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11841_, soundCategory, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public int m_8105_(ItemStack stack) {
        return ModularCrossbow.getPullTime(stack) + 3;
    }

    private static float getPullProgress(int useTicks, ItemStack stack) {
        float progress = (float)useTicks / (float)ModularCrossbow.getPullTime(stack);
        return Math.max(0.0f, Math.min(1.0f, progress));
    }

    public static int getPullTime(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        double drawTime = 25.0 - AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.BOW_DRAW_TIME);
        if (Double.isNaN(drawTime = Math.max(5.0, drawTime - drawTime / 5.0 * (double)i))) {
            return 5;
        }
        return (int)drawTime;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean loadProjectiles(LivingEntity shooter, ItemStack crossbow) {
        i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbow);
        v0 = j = i == 0 ? 1 : 3;
        if (!(shooter instanceof Player)) ** GOTO lbl-1000
        player = (Player)shooter;
        if (player.m_150110_().f_35937_) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isCreative = v1;
        itemStack = shooter.m_6298_(crossbow);
        for (k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack.m_41777_();
            }
            if (itemStack.m_41619_() && isCreative) {
                itemStack = new ItemStack((ItemLike)Items.f_42412_);
            }
            context = new MiapiProjectileEvents.CrossbowLoadingContext(shooter, crossbow, itemStack);
            if (((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_LOAD.invoker()).load(context).interruptsFurtherEvaluation()) {
                return false;
            }
            if (!ModularCrossbow.loadProjectile(shooter, crossbow, context.loadingProjectile, k > 0, isCreative)) {
                return false;
            }
            if (!((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_LOAD_AFTER.invoker()).load(context).interruptsFurtherEvaluation()) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity shooter, ItemStack crossbow, ItemStack projectile, boolean simulated, boolean creative) {
        ItemStack itemStack;
        if (projectile.m_41619_()) {
            return false;
        }
        if (!creative && !simulated) {
            itemStack = projectile.m_41620_(1);
            if (itemStack.m_41763_()) {
                itemStack.m_41622_(1, shooter, LivingEntity2 -> {});
            }
        } else {
            itemStack = projectile.m_41777_();
        }
        ModularCrossbow.putProjectile(crossbow, itemStack);
        return true;
    }

    public static void putProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundTag nbtCompound = crossbow.m_41784_();
        ListTag nbtList = nbtCompound.m_128425_("ChargedProjectiles", 9) ? nbtCompound.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag nbtCompound2 = new CompoundTag();
        projectile.m_41739_(nbtCompound2);
        nbtList.add((Object)nbtCompound2);
        nbtCompound.m_128365_("ChargedProjectiles", (Tag)nbtList);
        ModularItemCache.clearUUIDFor(crossbow);
    }

    private static void clearProjectiles(ItemStack crossbow) {
        CompoundTag nbtCompound = crossbow.m_41783_();
        if (nbtCompound != null) {
            ListTag nbtList = nbtCompound.m_128437_("ChargedProjectiles", 9);
            nbtList.clear();
            nbtCompound.m_128365_("ChargedProjectiles", (Tag)nbtList);
        }
        crossbow.m_41751_(nbtCompound);
        ModularItemCache.clearUUIDFor(crossbow);
    }

    private static void shoot(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.f_46443_) {
            MiapiProjectileEvents.ModularBowShotEvent event;
            AbstractArrow persistentProjectileEntity;
            AbstractArrow projectileEntity;
            boolean bl = projectile.m_150930_(Items.f_42688_);
            if (bl) {
                projectileEntity = new FireworkRocketEntity(world, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectileEntity = ModularCrossbow.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowUser = (CrossbowAttackMob)shooter;
                crossbowUser.m_5811_(crossbowUser.m_5448_(), crossbow, (Projectile)projectileEntity, simulated);
            } else {
                Vec3 vec3d = shooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                Vec3 vec3d2 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec3d2.m_252839_().rotate((Quaternionfc)quaternionf);
                projectileEntity.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.m_41622_(bl ? 3 : 1, shooter, e -> e.m_21190_(hand));
            if (projectileEntity instanceof AbstractArrow) {
                persistentProjectileEntity = projectileEntity;
                event = new MiapiProjectileEvents.ModularBowShotEvent(persistentProjectileEntity, crossbow, shooter);
                if (((MiapiProjectileEvents.ModularBowShot)MiapiProjectileEvents.MODULAR_BOW_SHOT.invoker()).call(event).interruptsFurtherEvaluation()) {
                    return;
                }
            }
            world.m_7967_((Entity)projectileEntity);
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
            if (projectileEntity instanceof AbstractArrow) {
                persistentProjectileEntity = projectileEntity;
                event = new MiapiProjectileEvents.ModularBowShotEvent(persistentProjectileEntity, crossbow, shooter);
                ((MiapiProjectileEvents.ModularBowShot)MiapiProjectileEvents.MODULAR_BOW_POST_SHOT.invoker()).call(event);
            }
        }
    }

    private static AbstractArrow createArrow(Level world, LivingEntity entity, ItemStack crossbow, ItemStack arrow) {
        ItemProjectileEntity persistentProjectileEntity;
        if (arrow.m_41720_() instanceof ModularItem && !(arrow.m_41720_() instanceof ArrowItem)) {
            persistentProjectileEntity = new ItemProjectileEntity(world, entity, arrow);
        } else {
            ArrowItem arrowItem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
            persistentProjectileEntity = arrowItem.m_6394_(world, arrow, entity);
            if (entity instanceof Player) {
                persistentProjectileEntity.m_36762_(true);
            }
        }
        persistentProjectileEntity.m_36740_(SoundEvents.f_11840_);
        persistentProjectileEntity.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            persistentProjectileEntity.m_36767_((byte)((double)((byte)i) + AttributeProperty.getActualValue(arrow, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_PIERCING)));
        }
        return persistentProjectileEntity;
    }

    /*
     * Unable to fully structure code
     */
    public static void shootAll(Level world, LivingEntity entity, InteractionHand hand, ItemStack stack, float speed, float divergence) {
        list = ModularCrossbow.getProjectiles(stack);
        fs = ModularCrossbow.getSoundPitches(entity.m_217043_());
        for (i = 0; i < list.size(); ++i) {
            itemStack = list.get(i);
            if (itemStack.m_41763_()) {
                // empty if block
            }
            if (!(entity instanceof Player)) ** GOTO lbl-1000
            playerEntity = (Player)entity;
            if (playerEntity.m_150110_().f_35937_) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = bl = false;
            }
            if (itemStack.m_41619_()) continue;
            if (i == 0) {
                ModularCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                ModularCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            ModularCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
        }
        ModularCrossbow.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(RandomSource random) {
        boolean bl = random.m_188499_();
        return new float[]{1.0f, ModularCrossbow.getSoundPitch(bl, random), ModularCrossbow.getSoundPitch(!bl, random)};
    }

    private static void postShoot(Level world, LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            if (!world.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayerEntity, stack);
            }
            serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        ModularCrossbow.clearProjectiles(stack);
        ModularCrossbow.m_40884_((ItemStack)stack, (boolean)false);
        ((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.invoker()).shoot(entity, stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (ModularCrossbow.m_40932_((ItemStack)itemStack)) {
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_SHOT.invoker()).shoot((LivingEntity)user, itemStack).interruptsFurtherEvaluation()) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            ModularCrossbow.shootAll(world, (LivingEntity)user, hand, itemStack, ModularCrossbow.getSpeed(itemStack), 1.0f);
            itemStack.m_41622_(1, (LivingEntity)user, p -> p.m_21190_(user.m_7655_()));
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (!user.m_6298_(itemStack).m_41619_()) {
            if (!ModularCrossbow.m_40932_((ItemStack)itemStack)) {
                this.f_40847_ = false;
                this.f_40848_ = false;
                user.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    private static float getSoundPitch(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static float getSpeed(ItemStack stack) {
        float baseSpeed = ModularCrossbow.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
        return baseSpeed += (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_SPEED);
    }

    public static List<ItemStack> getProjectiles(ItemStack crossbow) {
        ListTag nbtList;
        ArrayList list = Lists.newArrayList();
        CompoundTag nbtCompound = crossbow.m_41783_();
        if (nbtCompound != null && nbtCompound.m_128425_("ChargedProjectiles", 9) && (nbtList = nbtCompound.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag nbtCompound2 = nbtList.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)nbtCompound2));
            }
        }
        return list;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        List<ItemStack> list = ModularCrossbow.getProjectiles(stack);
        if (ModularCrossbow.m_40932_((ItemStack)stack) && !list.isEmpty()) {
            ItemStack itemStack = list.get(0);
            tooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(itemStack.m_41611_()));
            if (context.m_7050_() && itemStack.m_150930_(Items.f_42688_)) {
                ArrayList list2 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list2.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
        LoreProperty.appendLoreTop(stack, world, tooltip, context);
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> ModularBow.projectile.test((ItemStack)itemStack) || IsCrossbowShootAble.canCrossbowShoot(itemStack);
    }

    @Override
    public double getBaseDrawTime(ItemStack itemStack) {
        return 25.0;
    }
}

